package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CapacityReservationFleetState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState
}
object CapacityReservationFleetState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState
  ): zio.aws.ec2.model.CapacityReservationFleetState = value match {
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.SUBMITTED =>
      val r = submitted
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.MODIFYING =>
      val r = modifying
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.PARTIALLY_FULFILLED =>
      val r = partially_fulfilled
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.EXPIRING =>
      val r = expiring
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.EXPIRED =>
      val r = expired
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.CANCELLING =>
      val r = cancelling
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.UNKNOWN_TO_SDK_VERSION
  }
  case object submitted
      extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.SUBMITTED
  }
  case object modifying
      extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.MODIFYING
  }
  case object active extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.ACTIVE
  }
  case object partially_fulfilled
      extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.PARTIALLY_FULFILLED
  }
  case object expiring extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.EXPIRING
  }
  case object expired extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.EXPIRED
  }
  case object cancelling
      extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.CANCELLING
  }
  case object cancelled
      extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.CANCELLED
  }
  case object failed extends zio.aws.ec2.model.CapacityReservationFleetState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState.FAILED
  }
}
