package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CancelBatchErrorCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode
}
object CancelBatchErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode
  ): zio.aws.ec2.model.CancelBatchErrorCode = value match {
    case software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.FLEET_REQUEST_ID_DOES_NOT_EXIST =>
      val r = fleetRequestIdDoesNotExist
      r
    case software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.FLEET_REQUEST_ID_MALFORMED =>
      val r = fleetRequestIdMalformed
      r
    case software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.FLEET_REQUEST_NOT_IN_CANCELLABLE_STATE =>
      val r = fleetRequestNotInCancellableState
      r
    case software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.UNEXPECTED_ERROR =>
      val r = unexpectedError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.CancelBatchErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode =
      software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object fleetRequestIdDoesNotExist
      extends zio.aws.ec2.model.CancelBatchErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode =
      software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.FLEET_REQUEST_ID_DOES_NOT_EXIST
  }
  case object fleetRequestIdMalformed
      extends zio.aws.ec2.model.CancelBatchErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode =
      software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.FLEET_REQUEST_ID_MALFORMED
  }
  case object fleetRequestNotInCancellableState
      extends zio.aws.ec2.model.CancelBatchErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode =
      software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.FLEET_REQUEST_NOT_IN_CANCELLABLE_STATE
  }
  case object unexpectedError extends zio.aws.ec2.model.CancelBatchErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode =
      software.amazon.awssdk.services.ec2.model.CancelBatchErrorCode.UNEXPECTED_ERROR
  }
}
