package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AlternatePathHint(
    componentId: Optional[String] = Optional.Absent,
    componentArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AlternatePathHint = {
    import AlternatePathHint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AlternatePathHint
      .builder()
      .optionallyWith(componentId.map(value => value: java.lang.String))(
        _.componentId
      )
      .optionallyWith(componentArn.map(value => value: java.lang.String))(
        _.componentArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AlternatePathHint.ReadOnly =
    zio.aws.ec2.model.AlternatePathHint.wrap(buildAwsValue())
}
object AlternatePathHint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AlternatePathHint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AlternatePathHint =
      zio.aws.ec2.model.AlternatePathHint(
        componentId.map(value => value),
        componentArn.map(value => value)
      )
    def componentId: Optional[String]
    def componentArn: Optional[String]
    def getComponentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("componentId", componentId)
    def getComponentArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("componentArn", componentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AlternatePathHint
  ) extends zio.aws.ec2.model.AlternatePathHint.ReadOnly {
    override val componentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.componentId())
      .map(value => value: String)
    override val componentArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.componentArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AlternatePathHint
  ): zio.aws.ec2.model.AlternatePathHint.ReadOnly = new Wrapper(impl)
}
