package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AllocateIpamPoolCidrResponse(
    ipamPoolAllocation: Optional[zio.aws.ec2.model.IpamPoolAllocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse = {
    import AllocateIpamPoolCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse
      .builder()
      .optionallyWith(ipamPoolAllocation.map(value => value.buildAwsValue()))(
        _.ipamPoolAllocation
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly =
    zio.aws.ec2.model.AllocateIpamPoolCidrResponse.wrap(buildAwsValue())
}
object AllocateIpamPoolCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllocateIpamPoolCidrResponse =
      zio.aws.ec2.model.AllocateIpamPoolCidrResponse(
        ipamPoolAllocation.map(value => value.asEditable)
      )
    def ipamPoolAllocation
        : Optional[zio.aws.ec2.model.IpamPoolAllocation.ReadOnly]
    def getIpamPoolAllocation
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolAllocation.ReadOnly] =
      AwsError.unwrapOptionField("ipamPoolAllocation", ipamPoolAllocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse
  ) extends zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly {
    override val ipamPoolAllocation
        : Optional[zio.aws.ec2.model.IpamPoolAllocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamPoolAllocation())
        .map(value => zio.aws.ec2.model.IpamPoolAllocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse
  ): zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly = new Wrapper(impl)
}
