package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AdvertiseByoipCidrResponse(
    byoipCidr: Optional[zio.aws.ec2.model.ByoipCidr] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse = {
    import AdvertiseByoipCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse
      .builder()
      .optionallyWith(byoipCidr.map(value => value.buildAwsValue()))(
        _.byoipCidr
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AdvertiseByoipCidrResponse.ReadOnly =
    zio.aws.ec2.model.AdvertiseByoipCidrResponse.wrap(buildAwsValue())
}
object AdvertiseByoipCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AdvertiseByoipCidrResponse =
      zio.aws.ec2.model
        .AdvertiseByoipCidrResponse(byoipCidr.map(value => value.asEditable))
    def byoipCidr: Optional[zio.aws.ec2.model.ByoipCidr.ReadOnly]
    def getByoipCidr: ZIO[Any, AwsError, zio.aws.ec2.model.ByoipCidr.ReadOnly] =
      AwsError.unwrapOptionField("byoipCidr", byoipCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse
  ) extends zio.aws.ec2.model.AdvertiseByoipCidrResponse.ReadOnly {
    override val byoipCidr: Optional[zio.aws.ec2.model.ByoipCidr.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byoipCidr())
        .map(value => zio.aws.ec2.model.ByoipCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse
  ): zio.aws.ec2.model.AdvertiseByoipCidrResponse.ReadOnly = new Wrapper(impl)
}
