package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcPeeringConnectionVpcInfo(
    cidrBlock: Optional[String] = Optional.Absent,
    ipv6CidrBlockSet: Optional[Iterable[zio.aws.ec2.model.Ipv6CidrBlock]] =
      Optional.Absent,
    cidrBlockSet: Optional[Iterable[zio.aws.ec2.model.CidrBlock]] =
      Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    peeringOptions: Optional[
      zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription
    ] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    region: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo = {
    import VpcPeeringConnectionVpcInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo
      .builder()
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(
        ipv6CidrBlockSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrBlockSet)
      .optionallyWith(
        cidrBlockSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cidrBlockSet)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(peeringOptions.map(value => value.buildAwsValue()))(
        _.peeringOptions
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly =
    zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.wrap(buildAwsValue())
}
object VpcPeeringConnectionVpcInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcPeeringConnectionVpcInfo =
      zio.aws.ec2.model.VpcPeeringConnectionVpcInfo(
        cidrBlock.map(value => value),
        ipv6CidrBlockSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cidrBlockSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        peeringOptions.map(value => value.asEditable),
        vpcId.map(value => value),
        region.map(value => value)
      )
    def cidrBlock: Optional[String]
    def ipv6CidrBlockSet
        : Optional[List[zio.aws.ec2.model.Ipv6CidrBlock.ReadOnly]]
    def cidrBlockSet: Optional[List[zio.aws.ec2.model.CidrBlock.ReadOnly]]
    def ownerId: Optional[String]
    def peeringOptions: Optional[
      zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.ReadOnly
    ]
    def vpcId: Optional[String]
    def region: Optional[String]
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getIpv6CidrBlockSet
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Ipv6CidrBlock.ReadOnly]] =
      AwsError.unwrapOptionField("ipv6CidrBlockSet", ipv6CidrBlockSet)
    def getCidrBlockSet
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.CidrBlock.ReadOnly]] =
      AwsError.unwrapOptionField("cidrBlockSet", cidrBlockSet)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPeeringOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.ReadOnly
    ] = AwsError.unwrapOptionField("peeringOptions", peeringOptions)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo
  ) extends zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly {
    override val cidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => value: String)
    override val ipv6CidrBlockSet
        : Optional[List[zio.aws.ec2.model.Ipv6CidrBlock.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6CidrBlockSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Ipv6CidrBlock.wrap(item)
          }.toList
        )
    override val cidrBlockSet
        : Optional[List[zio.aws.ec2.model.CidrBlock.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrBlockSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CidrBlock.wrap(item)
          }.toList
        )
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val peeringOptions: Optional[
      zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.peeringOptions())
      .map(value =>
        zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.wrap(value)
      )
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo
  ): zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly = new Wrapper(impl)
}
