package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TrafficMirrorTargetType {
  def unwrap: software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType
}
object TrafficMirrorTargetType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType
  ): zio.aws.ec2.model.TrafficMirrorTargetType = value match {
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType.NETWORK_INTERFACE =>
      val r = `network-interface`
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType.NETWORK_LOAD_BALANCER =>
      val r = `network-load-balancer`
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType.GATEWAY_LOAD_BALANCER_ENDPOINT =>
      val r = `gateway-load-balancer-endpoint`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TrafficMirrorTargetType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object `network-interface`
      extends zio.aws.ec2.model.TrafficMirrorTargetType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType.NETWORK_INTERFACE
  }
  case object `network-load-balancer`
      extends zio.aws.ec2.model.TrafficMirrorTargetType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType.NETWORK_LOAD_BALANCER
  }
  case object `gateway-load-balancer-endpoint`
      extends zio.aws.ec2.model.TrafficMirrorTargetType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetType.GATEWAY_LOAD_BALANCER_ENDPOINT
  }
}
