package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class SpotFleetRequestConfig(
    activityStatus: Optional[zio.aws.ec2.model.ActivityStatus] =
      Optional.Absent,
    createTime: Optional[MillisecondDateTime] = Optional.Absent,
    spotFleetRequestConfig: Optional[
      zio.aws.ec2.model.SpotFleetRequestConfigData
    ] = Optional.Absent,
    spotFleetRequestId: Optional[String] = Optional.Absent,
    spotFleetRequestState: Optional[zio.aws.ec2.model.BatchState] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig = {
    import SpotFleetRequestConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig
      .builder()
      .optionallyWith(activityStatus.map(value => value.unwrap))(
        _.activityStatus
      )
      .optionallyWith(
        createTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        spotFleetRequestConfig.map(value => value.buildAwsValue())
      )(_.spotFleetRequestConfig)
      .optionallyWith(spotFleetRequestId.map(value => value: java.lang.String))(
        _.spotFleetRequestId
      )
      .optionallyWith(spotFleetRequestState.map(value => value.unwrap))(
        _.spotFleetRequestState
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly =
    zio.aws.ec2.model.SpotFleetRequestConfig.wrap(buildAwsValue())
}
object SpotFleetRequestConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotFleetRequestConfig =
      zio.aws.ec2.model.SpotFleetRequestConfig(
        activityStatus.map(value => value),
        createTime.map(value => value),
        spotFleetRequestConfig.map(value => value.asEditable),
        spotFleetRequestId.map(value => value),
        spotFleetRequestState.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def activityStatus: Optional[zio.aws.ec2.model.ActivityStatus]
    def createTime: Optional[MillisecondDateTime]
    def spotFleetRequestConfig
        : Optional[zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly]
    def spotFleetRequestId: Optional[String]
    def spotFleetRequestState: Optional[zio.aws.ec2.model.BatchState]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getActivityStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.ActivityStatus] =
      AwsError.unwrapOptionField("activityStatus", activityStatus)
    def getCreateTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getSpotFleetRequestConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly
    ] = AwsError.unwrapOptionField(
      "spotFleetRequestConfig",
      spotFleetRequestConfig
    )
    def getSpotFleetRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotFleetRequestId", spotFleetRequestId)
    def getSpotFleetRequestState
        : ZIO[Any, AwsError, zio.aws.ec2.model.BatchState] =
      AwsError.unwrapOptionField("spotFleetRequestState", spotFleetRequestState)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig
  ) extends zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly {
    override val activityStatus: Optional[zio.aws.ec2.model.ActivityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStatus())
        .map(value => zio.aws.ec2.model.ActivityStatus.wrap(value))
    override val createTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val spotFleetRequestConfig
        : Optional[zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotFleetRequestConfig())
        .map(value => zio.aws.ec2.model.SpotFleetRequestConfigData.wrap(value))
    override val spotFleetRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotFleetRequestId())
      .map(value => value: String)
    override val spotFleetRequestState: Optional[zio.aws.ec2.model.BatchState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotFleetRequestState())
        .map(value => zio.aws.ec2.model.BatchState.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig
  ): zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly = new Wrapper(impl)
}
