package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkInterfaceAssociation(
    allocationId: Optional[String] = Optional.Absent,
    associationId: Optional[String] = Optional.Absent,
    ipOwnerId: Optional[String] = Optional.Absent,
    publicDnsName: Optional[String] = Optional.Absent,
    publicIp: Optional[String] = Optional.Absent,
    customerOwnedIp: Optional[String] = Optional.Absent,
    carrierIp: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation = {
    import NetworkInterfaceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation
      .builder()
      .optionallyWith(allocationId.map(value => value: java.lang.String))(
        _.allocationId
      )
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(ipOwnerId.map(value => value: java.lang.String))(
        _.ipOwnerId
      )
      .optionallyWith(publicDnsName.map(value => value: java.lang.String))(
        _.publicDnsName
      )
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .optionallyWith(customerOwnedIp.map(value => value: java.lang.String))(
        _.customerOwnedIp
      )
      .optionallyWith(carrierIp.map(value => value: java.lang.String))(
        _.carrierIp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly =
    zio.aws.ec2.model.NetworkInterfaceAssociation.wrap(buildAwsValue())
}
object NetworkInterfaceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterfaceAssociation =
      zio.aws.ec2.model.NetworkInterfaceAssociation(
        allocationId.map(value => value),
        associationId.map(value => value),
        ipOwnerId.map(value => value),
        publicDnsName.map(value => value),
        publicIp.map(value => value),
        customerOwnedIp.map(value => value),
        carrierIp.map(value => value)
      )
    def allocationId: Optional[String]
    def associationId: Optional[String]
    def ipOwnerId: Optional[String]
    def publicDnsName: Optional[String]
    def publicIp: Optional[String]
    def customerOwnedIp: Optional[String]
    def carrierIp: Optional[String]
    def getAllocationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getIpOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipOwnerId", ipOwnerId)
    def getPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getCustomerOwnedIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOwnedIp", customerOwnedIp)
    def getCarrierIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("carrierIp", carrierIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation
  ) extends zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly {
    override val allocationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => value: String)
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val ipOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipOwnerId())
      .map(value => value: String)
    override val publicDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicDnsName())
      .map(value => value: String)
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
    override val customerOwnedIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerOwnedIp())
      .map(value => value: String)
    override val carrierIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.carrierIp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation
  ): zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly = new Wrapper(impl)
}
