package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupId,
  SubnetId,
  RouteTableId,
  VpcEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointRequest(
    vpcEndpointId: VpcEndpointId,
    resetPolicy: Optional[Boolean] = Optional.Absent,
    policyDocument: Optional[String] = Optional.Absent,
    addRouteTableIds: Optional[Iterable[RouteTableId]] = Optional.Absent,
    removeRouteTableIds: Optional[Iterable[RouteTableId]] = Optional.Absent,
    addSubnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    removeSubnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    addSecurityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    removeSecurityGroupIds: Optional[Iterable[SecurityGroupId]] =
      Optional.Absent,
    ipAddressType: Optional[zio.aws.ec2.model.IpAddressType] = Optional.Absent,
    dnsOptions: Optional[zio.aws.ec2.model.DnsOptionsSpecification] =
      Optional.Absent,
    privateDnsEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest = {
    import ModifyVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest
      .builder()
      .vpcEndpointId(VpcEndpointId.unwrap(vpcEndpointId): java.lang.String)
      .optionallyWith(resetPolicy.map(value => value: java.lang.Boolean))(
        _.resetPolicy
      )
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(
        addRouteTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addRouteTableIds)
      .optionallyWith(
        removeRouteTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeRouteTableIds)
      .optionallyWith(
        addSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addSubnetIds)
      .optionallyWith(
        removeSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeSubnetIds)
      .optionallyWith(
        addSecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addSecurityGroupIds)
      .optionallyWith(
        removeSecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeSecurityGroupIds)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(dnsOptions.map(value => value.buildAwsValue()))(
        _.dnsOptions
      )
      .optionallyWith(privateDnsEnabled.map(value => value: java.lang.Boolean))(
        _.privateDnsEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpcEndpointRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointRequest.wrap(buildAwsValue())
}
object ModifyVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpcEndpointRequest =
      zio.aws.ec2.model.ModifyVpcEndpointRequest(
        vpcEndpointId,
        resetPolicy.map(value => value),
        policyDocument.map(value => value),
        addRouteTableIds.map(value => value),
        removeRouteTableIds.map(value => value),
        addSubnetIds.map(value => value),
        removeSubnetIds.map(value => value),
        addSecurityGroupIds.map(value => value),
        removeSecurityGroupIds.map(value => value),
        ipAddressType.map(value => value),
        dnsOptions.map(value => value.asEditable),
        privateDnsEnabled.map(value => value)
      )
    def vpcEndpointId: VpcEndpointId
    def resetPolicy: Optional[Boolean]
    def policyDocument: Optional[String]
    def addRouteTableIds: Optional[List[RouteTableId]]
    def removeRouteTableIds: Optional[List[RouteTableId]]
    def addSubnetIds: Optional[List[SubnetId]]
    def removeSubnetIds: Optional[List[SubnetId]]
    def addSecurityGroupIds: Optional[List[SecurityGroupId]]
    def removeSecurityGroupIds: Optional[List[SecurityGroupId]]
    def ipAddressType: Optional[zio.aws.ec2.model.IpAddressType]
    def dnsOptions: Optional[zio.aws.ec2.model.DnsOptionsSpecification.ReadOnly]
    def privateDnsEnabled: Optional[Boolean]
    def getVpcEndpointId: ZIO[Any, Nothing, VpcEndpointId] =
      ZIO.succeed(vpcEndpointId)
    def getResetPolicy: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resetPolicy", resetPolicy)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getAddRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("addRouteTableIds", addRouteTableIds)
    def getRemoveRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("removeRouteTableIds", removeRouteTableIds)
    def getAddSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("addSubnetIds", addSubnetIds)
    def getRemoveSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("removeSubnetIds", removeSubnetIds)
    def getAddSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("addSecurityGroupIds", addSecurityGroupIds)
    def getRemoveSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField(
        "removeSecurityGroupIds",
        removeSecurityGroupIds
      )
    def getIpAddressType: ZIO[Any, AwsError, zio.aws.ec2.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getDnsOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DnsOptionsSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("dnsOptions", dnsOptions)
    def getPrivateDnsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privateDnsEnabled", privateDnsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest
  ) extends zio.aws.ec2.model.ModifyVpcEndpointRequest.ReadOnly {
    override val vpcEndpointId: VpcEndpointId =
      zio.aws.ec2.model.primitives.VpcEndpointId(impl.vpcEndpointId())
    override val resetPolicy: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.resetPolicy())
      .map(value => value: Boolean)
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
    override val addRouteTableIds: Optional[List[RouteTableId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addRouteTableIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.RouteTableId(item)
          }.toList
        )
    override val removeRouteTableIds: Optional[List[RouteTableId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeRouteTableIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.RouteTableId(item)
          }.toList
        )
    override val addSubnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.addSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val removeSubnetIds: Optional[List[SubnetId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeSubnetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SubnetId(item)
          }.toList
        )
    override val addSecurityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val removeSecurityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val ipAddressType: Optional[zio.aws.ec2.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.ec2.model.IpAddressType.wrap(value))
    override val dnsOptions
        : Optional[zio.aws.ec2.model.DnsOptionsSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsOptions())
        .map(value => zio.aws.ec2.model.DnsOptionsSpecification.wrap(value))
    override val privateDnsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest
  ): zio.aws.ec2.model.ModifyVpcEndpointRequest.ReadOnly = new Wrapper(impl)
}
