package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyHostsResponse(
    successful: Optional[Iterable[String]] = Optional.Absent,
    unsuccessful: Optional[Iterable[zio.aws.ec2.model.UnsuccessfulItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyHostsResponse = {
    import ModifyHostsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyHostsResponse
      .builder()
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.successful)
      .optionallyWith(
        unsuccessful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessful)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyHostsResponse.ReadOnly =
    zio.aws.ec2.model.ModifyHostsResponse.wrap(buildAwsValue())
}
object ModifyHostsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyHostsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyHostsResponse =
      zio.aws.ec2.model.ModifyHostsResponse(
        successful.map(value => value),
        unsuccessful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successful: Optional[List[String]]
    def unsuccessful
        : Optional[List[zio.aws.ec2.model.UnsuccessfulItem.ReadOnly]]
    def getSuccessful: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("successful", successful)
    def getUnsuccessful: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.UnsuccessfulItem.ReadOnly
    ]] = AwsError.unwrapOptionField("unsuccessful", unsuccessful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyHostsResponse
  ) extends zio.aws.ec2.model.ModifyHostsResponse.ReadOnly {
    override val successful: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.successful())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val unsuccessful
        : Optional[List[zio.aws.ec2.model.UnsuccessfulItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unsuccessful())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.UnsuccessfulItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyHostsResponse
  ): zio.aws.ec2.model.ModifyHostsResponse.ReadOnly = new Wrapper(impl)
}
