package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Blob
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportKeyPairRequest(
    keyName: String,
    publicKeyMaterial: Blob,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest = {
    import ImportKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest
      .builder()
      .keyName(keyName: java.lang.String)
      .publicKeyMaterial(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(publicKeyMaterial.toArray[Byte])
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportKeyPairRequest.ReadOnly =
    zio.aws.ec2.model.ImportKeyPairRequest.wrap(buildAwsValue())
}
object ImportKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportKeyPairRequest =
      zio.aws.ec2.model.ImportKeyPairRequest(
        keyName,
        publicKeyMaterial,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyName: String
    def publicKeyMaterial: Blob
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getKeyName: ZIO[Any, Nothing, String] = ZIO.succeed(keyName)
    def getPublicKeyMaterial: ZIO[Any, Nothing, Blob] =
      ZIO.succeed(publicKeyMaterial)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest
  ) extends zio.aws.ec2.model.ImportKeyPairRequest.ReadOnly {
    override val keyName: String = impl.keyName(): String
    override val publicKeyMaterial: Blob = zio.aws.ec2.model.primitives
      .Blob(zio.Chunk.fromArray(impl.publicKeyMaterial().asByteArrayUnsafe()))
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest
  ): zio.aws.ec2.model.ImportKeyPairRequest.ReadOnly = new Wrapper(impl)
}
