package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ImageAttributeName {
  def unwrap: software.amazon.awssdk.services.ec2.model.ImageAttributeName
}
object ImageAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ImageAttributeName
  ): zio.aws.ec2.model.ImageAttributeName = value match {
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.DESCRIPTION =>
      val r = description
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.KERNEL =>
      val r = kernel
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.RAMDISK =>
      val r = ramdisk
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.LAUNCH_PERMISSION =>
      val r = launchPermission
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.PRODUCT_CODES =>
      val r = productCodes
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.BLOCK_DEVICE_MAPPING =>
      val r = blockDeviceMapping
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.SRIOV_NET_SUPPORT =>
      val r = sriovNetSupport
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.BOOT_MODE =>
      val r = bootMode
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.TPM_SUPPORT =>
      val r = tpmSupport
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.UEFI_DATA =>
      val r = uefiData
      r
    case software.amazon.awssdk.services.ec2.model.ImageAttributeName.LAST_LAUNCHED_TIME =>
      val r = lastLaunchedTime
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object description extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.DESCRIPTION
  }
  case object kernel extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.KERNEL
  }
  case object ramdisk extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.RAMDISK
  }
  case object launchPermission extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.LAUNCH_PERMISSION
  }
  case object productCodes extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.PRODUCT_CODES
  }
  case object blockDeviceMapping extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.BLOCK_DEVICE_MAPPING
  }
  case object sriovNetSupport extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.SRIOV_NET_SUPPORT
  }
  case object bootMode extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.BOOT_MODE
  }
  case object tpmSupport extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.TPM_SUPPORT
  }
  case object uefiData extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.UEFI_DATA
  }
  case object lastLaunchedTime extends zio.aws.ec2.model.ImageAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageAttributeName =
      software.amazon.awssdk.services.ec2.model.ImageAttributeName.LAST_LAUNCHED_TIME
  }
}
