package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FleetType {
  def unwrap: software.amazon.awssdk.services.ec2.model.FleetType
}
object FleetType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FleetType
  ): zio.aws.ec2.model.FleetType = value match {
    case software.amazon.awssdk.services.ec2.model.FleetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FleetType.REQUEST =>
      val r = request
      r
    case software.amazon.awssdk.services.ec2.model.FleetType.MAINTAIN =>
      val r = maintain
      r
    case software.amazon.awssdk.services.ec2.model.FleetType.INSTANT =>
      val r = instant
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.FleetType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.FleetType =
      software.amazon.awssdk.services.ec2.model.FleetType.UNKNOWN_TO_SDK_VERSION
  }
  case object request extends zio.aws.ec2.model.FleetType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.FleetType =
      software.amazon.awssdk.services.ec2.model.FleetType.REQUEST
  }
  case object maintain extends zio.aws.ec2.model.FleetType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.FleetType =
      software.amazon.awssdk.services.ec2.model.FleetType.MAINTAIN
  }
  case object instant extends zio.aws.ec2.model.FleetType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.FleetType =
      software.amazon.awssdk.services.ec2.model.FleetType.INSTANT
  }
}
