package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventInformation(
    eventDescription: Optional[String] = Optional.Absent,
    eventSubType: Optional[String] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EventInformation = {
    import EventInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EventInformation
      .builder()
      .optionallyWith(eventDescription.map(value => value: java.lang.String))(
        _.eventDescription
      )
      .optionallyWith(eventSubType.map(value => value: java.lang.String))(
        _.eventSubType
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EventInformation.ReadOnly =
    zio.aws.ec2.model.EventInformation.wrap(buildAwsValue())
}
object EventInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EventInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EventInformation =
      zio.aws.ec2.model.EventInformation(
        eventDescription.map(value => value),
        eventSubType.map(value => value),
        instanceId.map(value => value)
      )
    def eventDescription: Optional[String]
    def eventSubType: Optional[String]
    def instanceId: Optional[String]
    def getEventDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventDescription", eventDescription)
    def getEventSubType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventSubType", eventSubType)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EventInformation
  ) extends zio.aws.ec2.model.EventInformation.ReadOnly {
    override val eventDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventDescription())
      .map(value => value: String)
    override val eventSubType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSubType())
      .map(value => value: String)
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EventInformation
  ): zio.aws.ec2.model.EventInformation.ReadOnly = new Wrapper(impl)
}
