package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DomainType {
  def unwrap: software.amazon.awssdk.services.ec2.model.DomainType
}
object DomainType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DomainType
  ): zio.aws.ec2.model.DomainType = value match {
    case software.amazon.awssdk.services.ec2.model.DomainType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DomainType.VPC =>
      val r = vpc
      r
    case software.amazon.awssdk.services.ec2.model.DomainType.STANDARD =>
      val r = standard
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.DomainType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.DomainType =
      software.amazon.awssdk.services.ec2.model.DomainType.UNKNOWN_TO_SDK_VERSION
  }
  case object vpc extends zio.aws.ec2.model.DomainType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.DomainType =
      software.amazon.awssdk.services.ec2.model.DomainType.VPC
  }
  case object standard extends zio.aws.ec2.model.DomainType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.DomainType =
      software.amazon.awssdk.services.ec2.model.DomainType.STANDARD
  }
}
