package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePublicIpv4PoolsResponse(
    publicIpv4Pools: Optional[Iterable[zio.aws.ec2.model.PublicIpv4Pool]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse = {
    import DescribePublicIpv4PoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse
      .builder()
      .optionallyWith(
        publicIpv4Pools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.publicIpv4Pools)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.ReadOnly =
    zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.wrap(buildAwsValue())
}
object DescribePublicIpv4PoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePublicIpv4PoolsResponse =
      zio.aws.ec2.model.DescribePublicIpv4PoolsResponse(
        publicIpv4Pools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def publicIpv4Pools
        : Optional[List[zio.aws.ec2.model.PublicIpv4Pool.ReadOnly]]
    def nextToken: Optional[String]
    def getPublicIpv4Pools
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PublicIpv4Pool.ReadOnly]] =
      AwsError.unwrapOptionField("publicIpv4Pools", publicIpv4Pools)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse
  ) extends zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.ReadOnly {
    override val publicIpv4Pools
        : Optional[List[zio.aws.ec2.model.PublicIpv4Pool.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicIpv4Pools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PublicIpv4Pool.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse
  ): zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.ReadOnly = new Wrapper(
    impl
  )
}
