package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  LocalGatewayMaxResults,
  LocalGatewayRoutetableId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayRouteTablesRequest(
    localGatewayRouteTableIds: Optional[Iterable[LocalGatewayRoutetableId]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[LocalGatewayMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest = {
    import DescribeLocalGatewayRouteTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest
      .builder()
      .optionallyWith(
        localGatewayRouteTableIds.map(value =>
          value.map { item =>
            LocalGatewayRoutetableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.localGatewayRouteTableIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => LocalGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayRouteTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest =
      zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest(
        localGatewayRouteTableIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def localGatewayRouteTableIds: Optional[List[LocalGatewayRoutetableId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[LocalGatewayMaxResults]
    def nextToken: Optional[String]
    def getLocalGatewayRouteTableIds
        : ZIO[Any, AwsError, List[LocalGatewayRoutetableId]] = AwsError
      .unwrapOptionField("localGatewayRouteTableIds", localGatewayRouteTableIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, LocalGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest
  ) extends zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest.ReadOnly {
    override val localGatewayRouteTableIds
        : Optional[List[LocalGatewayRoutetableId]] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayRouteTableIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.LocalGatewayRoutetableId(item)
        }.toList
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[LocalGatewayMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.LocalGatewayMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest
  ): zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest.ReadOnly =
    new Wrapper(impl)
}
