package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInternetGatewaysResponse(
    internetGateways: Optional[Iterable[zio.aws.ec2.model.InternetGateway]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse = {
    import DescribeInternetGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse
      .builder()
      .optionallyWith(
        internetGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.internetGateways)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInternetGatewaysResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInternetGatewaysResponse.wrap(buildAwsValue())
}
object DescribeInternetGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInternetGatewaysResponse =
      zio.aws.ec2.model.DescribeInternetGatewaysResponse(
        internetGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def internetGateways
        : Optional[List[zio.aws.ec2.model.InternetGateway.ReadOnly]]
    def nextToken: Optional[String]
    def getInternetGateways
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InternetGateway.ReadOnly]] =
      AwsError.unwrapOptionField("internetGateways", internetGateways)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse
  ) extends zio.aws.ec2.model.DescribeInternetGatewaysResponse.ReadOnly {
    override val internetGateways
        : Optional[List[zio.aws.ec2.model.InternetGateway.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.internetGateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InternetGateway.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse
  ): zio.aws.ec2.model.DescribeInternetGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
