package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHostReservationOfferingsResponse(
    nextToken: Optional[String] = Optional.Absent,
    offeringSet: Optional[Iterable[zio.aws.ec2.model.HostOffering]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse = {
    import DescribeHostReservationOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        offeringSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offeringSet)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeHostReservationOfferingsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeHostReservationOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeHostReservationOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeHostReservationOfferingsResponse =
      zio.aws.ec2.model.DescribeHostReservationOfferingsResponse(
        nextToken.map(value => value),
        offeringSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def offeringSet: Optional[List[zio.aws.ec2.model.HostOffering.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOfferingSet
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.HostOffering.ReadOnly]] =
      AwsError.unwrapOptionField("offeringSet", offeringSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse
  ) extends zio.aws.ec2.model.DescribeHostReservationOfferingsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val offeringSet
        : Optional[List[zio.aws.ec2.model.HostOffering.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.HostOffering.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse
  ): zio.aws.ec2.model.DescribeHostReservationOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
