package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayRouteTableId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayRouteTableRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest = {
    import DeleteTransitGatewayRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest =
      zio.aws.ec2.model
        .DeleteTransitGatewayRouteTableRequest(transitGatewayRouteTableId)
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest.ReadOnly =
    new Wrapper(impl)
}
