package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{RouteTableId, PrefixListResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteRouteRequest(
    destinationCidrBlock: Optional[String] = Optional.Absent,
    destinationIpv6CidrBlock: Optional[String] = Optional.Absent,
    destinationPrefixListId: Optional[PrefixListResourceId] = Optional.Absent,
    routeTableId: RouteTableId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteRouteRequest = {
    import DeleteRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteRouteRequest
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinationIpv6CidrBlock.map(value => value: java.lang.String)
      )(_.destinationIpv6CidrBlock)
      .optionallyWith(
        destinationPrefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.destinationPrefixListId)
      .routeTableId(RouteTableId.unwrap(routeTableId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteRouteRequest.ReadOnly =
    zio.aws.ec2.model.DeleteRouteRequest.wrap(buildAwsValue())
}
object DeleteRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteRouteRequest =
      zio.aws.ec2.model.DeleteRouteRequest(
        destinationCidrBlock.map(value => value),
        destinationIpv6CidrBlock.map(value => value),
        destinationPrefixListId.map(value => value),
        routeTableId
      )
    def destinationCidrBlock: Optional[String]
    def destinationIpv6CidrBlock: Optional[String]
    def destinationPrefixListId: Optional[PrefixListResourceId]
    def routeTableId: RouteTableId
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinationIpv6CidrBlock: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("destinationIpv6CidrBlock", destinationIpv6CidrBlock)
    def getDestinationPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField(
        "destinationPrefixListId",
        destinationPrefixListId
      )
    def getRouteTableId: ZIO[Any, Nothing, RouteTableId] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteRouteRequest
  ) extends zio.aws.ec2.model.DeleteRouteRequest.ReadOnly {
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val destinationIpv6CidrBlock: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationIpv6CidrBlock())
        .map(value => value: String)
    override val destinationPrefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val routeTableId: RouteTableId =
      zio.aws.ec2.model.primitives.RouteTableId(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteRouteRequest
  ): zio.aws.ec2.model.DeleteRouteRequest.ReadOnly = new Wrapper(impl)
}
