package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.PrefixListResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteManagedPrefixListRequest(
    prefixListId: PrefixListResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest = {
    import DeleteManagedPrefixListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest
      .builder()
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteManagedPrefixListRequest.ReadOnly =
    zio.aws.ec2.model.DeleteManagedPrefixListRequest.wrap(buildAwsValue())
}
object DeleteManagedPrefixListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteManagedPrefixListRequest =
      zio.aws.ec2.model.DeleteManagedPrefixListRequest(prefixListId)
    def prefixListId: PrefixListResourceId
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest
  ) extends zio.aws.ec2.model.DeleteManagedPrefixListRequest.ReadOnly {
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest
  ): zio.aws.ec2.model.DeleteManagedPrefixListRequest.ReadOnly = new Wrapper(
    impl
  )
}
