package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ClientVpnEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteClientVpnEndpointRequest(
    clientVpnEndpointId: ClientVpnEndpointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest = {
    import DeleteClientVpnEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteClientVpnEndpointRequest.ReadOnly =
    zio.aws.ec2.model.DeleteClientVpnEndpointRequest.wrap(buildAwsValue())
}
object DeleteClientVpnEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteClientVpnEndpointRequest =
      zio.aws.ec2.model.DeleteClientVpnEndpointRequest(clientVpnEndpointId)
    def clientVpnEndpointId: ClientVpnEndpointId
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest
  ) extends zio.aws.ec2.model.DeleteClientVpnEndpointRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest
  ): zio.aws.ec2.model.DeleteClientVpnEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
