package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateReplaceRootVolumeTaskResponse(
    replaceRootVolumeTask: Optional[zio.aws.ec2.model.ReplaceRootVolumeTask] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskResponse = {
    import CreateReplaceRootVolumeTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskResponse
      .builder()
      .optionallyWith(
        replaceRootVolumeTask.map(value => value.buildAwsValue())
      )(_.replaceRootVolumeTask)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.ReadOnly =
    zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.wrap(buildAwsValue())
}
object CreateReplaceRootVolumeTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse =
      zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse(
        replaceRootVolumeTask.map(value => value.asEditable)
      )
    def replaceRootVolumeTask
        : Optional[zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly]
    def getReplaceRootVolumeTask
        : ZIO[Any, AwsError, zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly] =
      AwsError.unwrapOptionField("replaceRootVolumeTask", replaceRootVolumeTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskResponse
  ) extends zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.ReadOnly {
    override val replaceRootVolumeTask
        : Optional[zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replaceRootVolumeTask())
        .map(value => zio.aws.ec2.model.ReplaceRootVolumeTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskResponse
  ): zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.ReadOnly =
    new Wrapper(impl)
}
