package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocalGatewayRouteResponse(
    route: Optional[zio.aws.ec2.model.LocalGatewayRoute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse = {
    import CreateLocalGatewayRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse
      .builder()
      .optionallyWith(route.map(value => value.buildAwsValue()))(_.route)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateLocalGatewayRouteResponse.ReadOnly =
    zio.aws.ec2.model.CreateLocalGatewayRouteResponse.wrap(buildAwsValue())
}
object CreateLocalGatewayRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateLocalGatewayRouteResponse =
      zio.aws.ec2.model
        .CreateLocalGatewayRouteResponse(route.map(value => value.asEditable))
    def route: Optional[zio.aws.ec2.model.LocalGatewayRoute.ReadOnly]
    def getRoute
        : ZIO[Any, AwsError, zio.aws.ec2.model.LocalGatewayRoute.ReadOnly] =
      AwsError.unwrapOptionField("route", route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse
  ) extends zio.aws.ec2.model.CreateLocalGatewayRouteResponse.ReadOnly {
    override val route: Optional[zio.aws.ec2.model.LocalGatewayRoute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.route())
        .map(value => zio.aws.ec2.model.LocalGatewayRoute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse
  ): zio.aws.ec2.model.CreateLocalGatewayRouteResponse.ReadOnly = new Wrapper(
    impl
  )
}
