package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDhcpOptionsResponse(
    dhcpOptions: Optional[zio.aws.ec2.model.DhcpOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse = {
    import CreateDhcpOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse
      .builder()
      .optionallyWith(dhcpOptions.map(value => value.buildAwsValue()))(
        _.dhcpOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateDhcpOptionsResponse.ReadOnly =
    zio.aws.ec2.model.CreateDhcpOptionsResponse.wrap(buildAwsValue())
}
object CreateDhcpOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateDhcpOptionsResponse =
      zio.aws.ec2.model
        .CreateDhcpOptionsResponse(dhcpOptions.map(value => value.asEditable))
    def dhcpOptions: Optional[zio.aws.ec2.model.DhcpOptions.ReadOnly]
    def getDhcpOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.DhcpOptions.ReadOnly] =
      AwsError.unwrapOptionField("dhcpOptions", dhcpOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse
  ) extends zio.aws.ec2.model.CreateDhcpOptionsResponse.ReadOnly {
    override val dhcpOptions: Optional[zio.aws.ec2.model.DhcpOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dhcpOptions())
        .map(value => zio.aws.ec2.model.DhcpOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse
  ): zio.aws.ec2.model.CreateDhcpOptionsResponse.ReadOnly = new Wrapper(impl)
}
