package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CapacityReservationOptionsRequest(
    usageStrategy: Optional[
      zio.aws.ec2.model.FleetCapacityReservationUsageStrategy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservationOptionsRequest = {
    import CapacityReservationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservationOptionsRequest
      .builder()
      .optionallyWith(usageStrategy.map(value => value.unwrap))(_.usageStrategy)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityReservationOptionsRequest.ReadOnly =
    zio.aws.ec2.model.CapacityReservationOptionsRequest.wrap(buildAwsValue())
}
object CapacityReservationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservationOptionsRequest =
      zio.aws.ec2.model
        .CapacityReservationOptionsRequest(usageStrategy.map(value => value))
    def usageStrategy
        : Optional[zio.aws.ec2.model.FleetCapacityReservationUsageStrategy]
    def getUsageStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetCapacityReservationUsageStrategy
    ] = AwsError.unwrapOptionField("usageStrategy", usageStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationOptionsRequest
  ) extends zio.aws.ec2.model.CapacityReservationOptionsRequest.ReadOnly {
    override val usageStrategy
        : Optional[zio.aws.ec2.model.FleetCapacityReservationUsageStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageStrategy())
        .map(value =>
          zio.aws.ec2.model.FleetCapacityReservationUsageStrategy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationOptionsRequest
  ): zio.aws.ec2.model.CapacityReservationOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
