package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AttachmentStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.AttachmentStatus
}
object AttachmentStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AttachmentStatus
  ): zio.aws.ec2.model.AttachmentStatus = value match {
    case software.amazon.awssdk.services.ec2.model.AttachmentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AttachmentStatus.ATTACHING =>
      val r = attaching
      r
    case software.amazon.awssdk.services.ec2.model.AttachmentStatus.ATTACHED =>
      val r = attached
      r
    case software.amazon.awssdk.services.ec2.model.AttachmentStatus.DETACHING =>
      val r = detaching
      r
    case software.amazon.awssdk.services.ec2.model.AttachmentStatus.DETACHED =>
      val r = detached
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.AttachmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AttachmentStatus =
      software.amazon.awssdk.services.ec2.model.AttachmentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object attaching extends zio.aws.ec2.model.AttachmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AttachmentStatus =
      software.amazon.awssdk.services.ec2.model.AttachmentStatus.ATTACHING
  }
  case object attached extends zio.aws.ec2.model.AttachmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AttachmentStatus =
      software.amazon.awssdk.services.ec2.model.AttachmentStatus.ATTACHED
  }
  case object detaching extends zio.aws.ec2.model.AttachmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AttachmentStatus =
      software.amazon.awssdk.services.ec2.model.AttachmentStatus.DETACHING
  }
  case object detached extends zio.aws.ec2.model.AttachmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AttachmentStatus =
      software.amazon.awssdk.services.ec2.model.AttachmentStatus.DETACHED
  }
}
