package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, InternetGatewayId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttachInternetGatewayRequest(
    internetGatewayId: InternetGatewayId,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest = {
    import AttachInternetGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest
      .builder()
      .internetGatewayId(
        InternetGatewayId.unwrap(internetGatewayId): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachInternetGatewayRequest.ReadOnly =
    zio.aws.ec2.model.AttachInternetGatewayRequest.wrap(buildAwsValue())
}
object AttachInternetGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachInternetGatewayRequest =
      zio.aws.ec2.model.AttachInternetGatewayRequest(internetGatewayId, vpcId)
    def internetGatewayId: InternetGatewayId
    def vpcId: VpcId
    def getInternetGatewayId: ZIO[Any, Nothing, InternetGatewayId] =
      ZIO.succeed(internetGatewayId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest
  ) extends zio.aws.ec2.model.AttachInternetGatewayRequest.ReadOnly {
    override val internetGatewayId: InternetGatewayId =
      zio.aws.ec2.model.primitives.InternetGatewayId(impl.internetGatewayId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest
  ): zio.aws.ec2.model.AttachInternetGatewayRequest.ReadOnly = new Wrapper(impl)
}
