package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AddressAttributeName {
  def unwrap: software.amazon.awssdk.services.ec2.model.AddressAttributeName
}
object AddressAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AddressAttributeName
  ): zio.aws.ec2.model.AddressAttributeName = value match {
    case software.amazon.awssdk.services.ec2.model.AddressAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AddressAttributeName.DOMAIN_NAME =>
      val r = `domain-name`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AddressAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AddressAttributeName =
      software.amazon.awssdk.services.ec2.model.AddressAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object `domain-name` extends zio.aws.ec2.model.AddressAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AddressAttributeName =
      software.amazon.awssdk.services.ec2.model.AddressAttributeName.DOMAIN_NAME
  }
}
