package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VolumeModificationState {
  def unwrap: software.amazon.awssdk.services.ec2.model.VolumeModificationState
}
object VolumeModificationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VolumeModificationState
  ): zio.aws.ec2.model.VolumeModificationState = value match {
    case software.amazon.awssdk.services.ec2.model.VolumeModificationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VolumeModificationState.MODIFYING =>
      val r = modifying
      r
    case software.amazon.awssdk.services.ec2.model.VolumeModificationState.OPTIMIZING =>
      val r = optimizing
      r
    case software.amazon.awssdk.services.ec2.model.VolumeModificationState.COMPLETED =>
      val r = completed
      r
    case software.amazon.awssdk.services.ec2.model.VolumeModificationState.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.VolumeModificationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeModificationState =
      software.amazon.awssdk.services.ec2.model.VolumeModificationState.UNKNOWN_TO_SDK_VERSION
  }
  case object modifying extends zio.aws.ec2.model.VolumeModificationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeModificationState =
      software.amazon.awssdk.services.ec2.model.VolumeModificationState.MODIFYING
  }
  case object optimizing extends zio.aws.ec2.model.VolumeModificationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeModificationState =
      software.amazon.awssdk.services.ec2.model.VolumeModificationState.OPTIMIZING
  }
  case object completed extends zio.aws.ec2.model.VolumeModificationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeModificationState =
      software.amazon.awssdk.services.ec2.model.VolumeModificationState.COMPLETED
  }
  case object failed extends zio.aws.ec2.model.VolumeModificationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeModificationState =
      software.amazon.awssdk.services.ec2.model.VolumeModificationState.FAILED
  }
}
