package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TagDescription(
    key: Optional[String] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceType: Optional[zio.aws.ec2.model.ResourceType] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TagDescription = {
    import TagDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TagDescription
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TagDescription.ReadOnly =
    zio.aws.ec2.model.TagDescription.wrap(buildAwsValue())
}
object TagDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TagDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TagDescription =
      zio.aws.ec2.model.TagDescription(
        key.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        value.map(value => value)
      )
    def key: Optional[String]
    def resourceId: Optional[String]
    def resourceType: Optional[zio.aws.ec2.model.ResourceType]
    def value: Optional[String]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[Any, AwsError, zio.aws.ec2.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TagDescription
  ) extends zio.aws.ec2.model.TagDescription.ReadOnly {
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceType: Optional[zio.aws.ec2.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.ec2.model.ResourceType.wrap(value))
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TagDescription
  ): zio.aws.ec2.model.TagDescription.ReadOnly = new Wrapper(impl)
}
