package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SpotCapacityRebalance(
    replacementStrategy: Optional[zio.aws.ec2.model.ReplacementStrategy] =
      Optional.Absent,
    terminationDelay: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance = {
    import SpotCapacityRebalance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance
      .builder()
      .optionallyWith(replacementStrategy.map(value => value.unwrap))(
        _.replacementStrategy
      )
      .optionallyWith(terminationDelay.map(value => value: java.lang.Integer))(
        _.terminationDelay
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotCapacityRebalance.ReadOnly =
    zio.aws.ec2.model.SpotCapacityRebalance.wrap(buildAwsValue())
}
object SpotCapacityRebalance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotCapacityRebalance =
      zio.aws.ec2.model.SpotCapacityRebalance(
        replacementStrategy.map(value => value),
        terminationDelay.map(value => value)
      )
    def replacementStrategy: Optional[zio.aws.ec2.model.ReplacementStrategy]
    def terminationDelay: Optional[Integer]
    def getReplacementStrategy
        : ZIO[Any, AwsError, zio.aws.ec2.model.ReplacementStrategy] =
      AwsError.unwrapOptionField("replacementStrategy", replacementStrategy)
    def getTerminationDelay: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("terminationDelay", terminationDelay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance
  ) extends zio.aws.ec2.model.SpotCapacityRebalance.ReadOnly {
    override val replacementStrategy
        : Optional[zio.aws.ec2.model.ReplacementStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replacementStrategy())
        .map(value => zio.aws.ec2.model.ReplacementStrategy.wrap(value))
    override val terminationDelay: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.terminationDelay())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance
  ): zio.aws.ec2.model.SpotCapacityRebalance.ReadOnly = new Wrapper(impl)
}
