package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  TransitGatewayMaxResults,
  TransitGatewayMulticastDomainId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchTransitGatewayMulticastGroupsRequest(
    transitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[TransitGatewayMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest = {
    import SearchTransitGatewayMulticastGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value =>
          TransitGatewayMulticastDomainId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => TransitGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest.ReadOnly =
    zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest
      .wrap(buildAwsValue())
}
object SearchTransitGatewayMulticastGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest =
      zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest(
        transitGatewayMulticastDomainId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[TransitGatewayMaxResults]
    def nextToken: Optional[String]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, AwsError, TransitGatewayMulticastDomainId] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TransitGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest
  ) extends zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayMulticastDomainId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId(value)
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[TransitGatewayMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.TransitGatewayMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest
  ): zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
