package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  RunInstancesUserData,
  KeyPairName,
  SecurityGroupId,
  Integer,
  KernelId,
  SecurityGroupName,
  ImageId,
  RamdiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RunInstancesRequest(
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = Optional.Absent,
    imageId: Optional[ImageId] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    ipv6AddressCount: Optional[Integer] = Optional.Absent,
    ipv6Addresses: Optional[Iterable[zio.aws.ec2.model.InstanceIpv6Address]] =
      Optional.Absent,
    kernelId: Optional[KernelId] = Optional.Absent,
    keyName: Optional[KeyPairName] = Optional.Absent,
    maxCount: Integer,
    minCount: Integer,
    monitoring: Optional[zio.aws.ec2.model.RunInstancesMonitoringEnabled] =
      Optional.Absent,
    placement: Optional[zio.aws.ec2.model.Placement] = Optional.Absent,
    ramdiskId: Optional[RamdiskId] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupName]] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    userData: Optional[RunInstancesUserData] = Optional.Absent,
    additionalInfo: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    disableApiTermination: Optional[Boolean] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    iamInstanceProfile: Optional[
      zio.aws.ec2.model.IamInstanceProfileSpecification
    ] = Optional.Absent,
    instanceInitiatedShutdownBehavior: Optional[
      zio.aws.ec2.model.ShutdownBehavior
    ] = Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification]
    ] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    elasticGpuSpecification: Optional[
      Iterable[zio.aws.ec2.model.ElasticGpuSpecification]
    ] = Optional.Absent,
    elasticInferenceAccelerators: Optional[
      Iterable[zio.aws.ec2.model.ElasticInferenceAccelerator]
    ] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    launchTemplate: Optional[zio.aws.ec2.model.LaunchTemplateSpecification] =
      Optional.Absent,
    instanceMarketOptions: Optional[
      zio.aws.ec2.model.InstanceMarketOptionsRequest
    ] = Optional.Absent,
    creditSpecification: Optional[
      zio.aws.ec2.model.CreditSpecificationRequest
    ] = Optional.Absent,
    cpuOptions: Optional[zio.aws.ec2.model.CpuOptionsRequest] = Optional.Absent,
    capacityReservationSpecification: Optional[
      zio.aws.ec2.model.CapacityReservationSpecification
    ] = Optional.Absent,
    hibernationOptions: Optional[zio.aws.ec2.model.HibernationOptionsRequest] =
      Optional.Absent,
    licenseSpecifications: Optional[
      Iterable[zio.aws.ec2.model.LicenseConfigurationRequest]
    ] = Optional.Absent,
    metadataOptions: Optional[
      zio.aws.ec2.model.InstanceMetadataOptionsRequest
    ] = Optional.Absent,
    enclaveOptions: Optional[zio.aws.ec2.model.EnclaveOptionsRequest] =
      Optional.Absent,
    privateDnsNameOptions: Optional[
      zio.aws.ec2.model.PrivateDnsNameOptionsRequest
    ] = Optional.Absent,
    maintenanceOptions: Optional[
      zio.aws.ec2.model.InstanceMaintenanceOptionsRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RunInstancesRequest = {
    import RunInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RunInstancesRequest
      .builder()
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(ipv6AddressCount.map(value => value: java.lang.Integer))(
        _.ipv6AddressCount
      )
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .maxCount(maxCount: java.lang.Integer)
      .minCount(minCount: java.lang.Integer)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        ramdiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        userData.map(value =>
          RunInstancesUserData.unwrap(value): java.lang.String
        )
      )(_.userData)
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        disableApiTermination.map(value => value: java.lang.Boolean)
      )(_.disableApiTermination)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.unwrap)
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        elasticGpuSpecification.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuSpecification)
      .optionallyWith(
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticInferenceAccelerators)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(
        instanceMarketOptions.map(value => value.buildAwsValue())
      )(_.instanceMarketOptions)
      .optionallyWith(creditSpecification.map(value => value.buildAwsValue()))(
        _.creditSpecification
      )
      .optionallyWith(cpuOptions.map(value => value.buildAwsValue()))(
        _.cpuOptions
      )
      .optionallyWith(
        capacityReservationSpecification.map(value => value.buildAwsValue())
      )(_.capacityReservationSpecification)
      .optionallyWith(hibernationOptions.map(value => value.buildAwsValue()))(
        _.hibernationOptions
      )
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(
        privateDnsNameOptions.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptions)
      .optionallyWith(maintenanceOptions.map(value => value.buildAwsValue()))(
        _.maintenanceOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RunInstancesRequest.ReadOnly =
    zio.aws.ec2.model.RunInstancesRequest.wrap(buildAwsValue())
}
object RunInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RunInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RunInstancesRequest =
      zio.aws.ec2.model.RunInstancesRequest(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        instanceType.map(value => value),
        ipv6AddressCount.map(value => value),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kernelId.map(value => value),
        keyName.map(value => value),
        maxCount,
        minCount,
        monitoring.map(value => value.asEditable),
        placement.map(value => value.asEditable),
        ramdiskId.map(value => value),
        securityGroupIds.map(value => value),
        securityGroups.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value),
        additionalInfo.map(value => value),
        clientToken.map(value => value),
        disableApiTermination.map(value => value),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        instanceInitiatedShutdownBehavior.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateIpAddress.map(value => value),
        elasticGpuSpecification.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchTemplate.map(value => value.asEditable),
        instanceMarketOptions.map(value => value.asEditable),
        creditSpecification.map(value => value.asEditable),
        cpuOptions.map(value => value.asEditable),
        capacityReservationSpecification.map(value => value.asEditable),
        hibernationOptions.map(value => value.asEditable),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metadataOptions.map(value => value.asEditable),
        enclaveOptions.map(value => value.asEditable),
        privateDnsNameOptions.map(value => value.asEditable),
        maintenanceOptions.map(value => value.asEditable)
      )
    def blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def imageId: Optional[ImageId]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def ipv6AddressCount: Optional[Integer]
    def ipv6Addresses
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]]
    def kernelId: Optional[KernelId]
    def keyName: Optional[KeyPairName]
    def maxCount: Integer
    def minCount: Integer
    def monitoring
        : Optional[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly]
    def placement: Optional[zio.aws.ec2.model.Placement.ReadOnly]
    def ramdiskId: Optional[RamdiskId]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def securityGroups: Optional[List[SecurityGroupName]]
    def subnetId: Optional[SubnetId]
    def userData: Optional[RunInstancesUserData]
    def additionalInfo: Optional[String]
    def clientToken: Optional[String]
    def disableApiTermination: Optional[Boolean]
    def ebsOptimized: Optional[Boolean]
    def iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly]
    def instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.ShutdownBehavior]
    def networkInterfaces: Optional[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ]
    def privateIpAddress: Optional[String]
    def elasticGpuSpecification
        : Optional[List[zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly]]
    def elasticInferenceAccelerators
        : Optional[List[zio.aws.ec2.model.ElasticInferenceAccelerator.ReadOnly]]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def launchTemplate
        : Optional[zio.aws.ec2.model.LaunchTemplateSpecification.ReadOnly]
    def instanceMarketOptions
        : Optional[zio.aws.ec2.model.InstanceMarketOptionsRequest.ReadOnly]
    def creditSpecification
        : Optional[zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly]
    def cpuOptions: Optional[zio.aws.ec2.model.CpuOptionsRequest.ReadOnly]
    def capacityReservationSpecification
        : Optional[zio.aws.ec2.model.CapacityReservationSpecification.ReadOnly]
    def hibernationOptions
        : Optional[zio.aws.ec2.model.HibernationOptionsRequest.ReadOnly]
    def licenseSpecifications
        : Optional[List[zio.aws.ec2.model.LicenseConfigurationRequest.ReadOnly]]
    def metadataOptions
        : Optional[zio.aws.ec2.model.InstanceMetadataOptionsRequest.ReadOnly]
    def enclaveOptions
        : Optional[zio.aws.ec2.model.EnclaveOptionsRequest.ReadOnly]
    def privateDnsNameOptions
        : Optional[zio.aws.ec2.model.PrivateDnsNameOptionsRequest.ReadOnly]
    def maintenanceOptions
        : Optional[zio.aws.ec2.model.InstanceMaintenanceOptionsRequest.ReadOnly]
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getIpv6AddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6AddressCount", ipv6AddressCount)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMaxCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxCount)
    def getMinCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(minCount)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.Placement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getRamdiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupName]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, RunInstancesUserData] =
      AwsError.unwrapOptionField("userData", userData)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDisableApiTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.ShutdownBehavior] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getElasticGpuSpecification: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticGpuSpecification",
      elasticGpuSpecification
    )
    def getElasticInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticInferenceAccelerator.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticInferenceAccelerators",
      elasticInferenceAccelerators
    )
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getInstanceMarketOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMarketOptionsRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceMarketOptions", instanceMarketOptions)
    def getCreditSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("creditSpecification", creditSpecification)
    def getCpuOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.CpuOptionsRequest.ReadOnly] =
      AwsError.unwrapOptionField("cpuOptions", cpuOptions)
    def getCapacityReservationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationSpecification",
      capacityReservationSpecification
    )
    def getHibernationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.HibernationOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("hibernationOptions", hibernationOptions)
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LicenseConfigurationRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMetadataOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getEnclaveOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.EnclaveOptionsRequest.ReadOnly] =
      AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getPrivateDnsNameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PrivateDnsNameOptionsRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("privateDnsNameOptions", privateDnsNameOptions)
    def getMaintenanceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMaintenanceOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("maintenanceOptions", maintenanceOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RunInstancesRequest
  ) extends zio.aws.ec2.model.RunInstancesRequest.ReadOnly {
    override val blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockDeviceMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
          }.toList
        )
    override val imageId: Optional[ImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val ipv6AddressCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6AddressCount())
      .map(value => value: Integer)
    override val ipv6Addresses
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceIpv6Address.wrap(item)
          }.toList
        )
    override val kernelId: Optional[KernelId] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val keyName: Optional[KeyPairName] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val maxCount: Integer = impl.maxCount(): Integer
    override val minCount: Integer = impl.minCount(): Integer
    override val monitoring
        : Optional[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoring())
        .map(value =>
          zio.aws.ec2.model.RunInstancesMonitoringEnabled.wrap(value)
        )
    override val placement: Optional[zio.aws.ec2.model.Placement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.ec2.model.Placement.wrap(value))
    override val ramdiskId: Optional[RamdiskId] = zio.aws.core.internal
      .optionalFromNullable(impl.ramdiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val securityGroups: Optional[List[SecurityGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupName(item)
          }.toList
        )
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Optional[RunInstancesUserData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userData())
        .map(value => zio.aws.ec2.model.primitives.RunInstancesUserData(value))
    override val additionalInfo: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInfo())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val disableApiTermination: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableApiTermination())
        .map(value => value: Boolean)
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfile())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileSpecification.wrap(value)
        )
    override val instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.ShutdownBehavior] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.ShutdownBehavior.wrap(value))
    override val networkInterfaces: Optional[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.wrap(item)
        }.toList
      )
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val elasticGpuSpecification
        : Optional[List[zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticGpuSpecification())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ElasticGpuSpecification.wrap(item)
          }.toList
        )
    override val elasticInferenceAccelerators: Optional[
      List[zio.aws.ec2.model.ElasticInferenceAccelerator.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticInferenceAccelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ElasticInferenceAccelerator.wrap(item)
        }.toList
      )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val launchTemplate
        : Optional[zio.aws.ec2.model.LaunchTemplateSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplate())
        .map(value => zio.aws.ec2.model.LaunchTemplateSpecification.wrap(value))
    override val instanceMarketOptions
        : Optional[zio.aws.ec2.model.InstanceMarketOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMarketOptions())
        .map(value =>
          zio.aws.ec2.model.InstanceMarketOptionsRequest.wrap(value)
        )
    override val creditSpecification
        : Optional[zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creditSpecification())
        .map(value => zio.aws.ec2.model.CreditSpecificationRequest.wrap(value))
    override val cpuOptions
        : Optional[zio.aws.ec2.model.CpuOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuOptions())
        .map(value => zio.aws.ec2.model.CpuOptionsRequest.wrap(value))
    override val capacityReservationSpecification: Optional[
      zio.aws.ec2.model.CapacityReservationSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationSpecification())
      .map(value =>
        zio.aws.ec2.model.CapacityReservationSpecification.wrap(value)
      )
    override val hibernationOptions
        : Optional[zio.aws.ec2.model.HibernationOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hibernationOptions())
        .map(value => zio.aws.ec2.model.HibernationOptionsRequest.wrap(value))
    override val licenseSpecifications: Optional[
      List[zio.aws.ec2.model.LicenseConfigurationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LicenseConfigurationRequest.wrap(item)
        }.toList
      )
    override val metadataOptions
        : Optional[zio.aws.ec2.model.InstanceMetadataOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataOptions())
        .map(value =>
          zio.aws.ec2.model.InstanceMetadataOptionsRequest.wrap(value)
        )
    override val enclaveOptions
        : Optional[zio.aws.ec2.model.EnclaveOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enclaveOptions())
        .map(value => zio.aws.ec2.model.EnclaveOptionsRequest.wrap(value))
    override val privateDnsNameOptions
        : Optional[zio.aws.ec2.model.PrivateDnsNameOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateDnsNameOptions())
        .map(value =>
          zio.aws.ec2.model.PrivateDnsNameOptionsRequest.wrap(value)
        )
    override val maintenanceOptions: Optional[
      zio.aws.ec2.model.InstanceMaintenanceOptionsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceOptions())
      .map(value =>
        zio.aws.ec2.model.InstanceMaintenanceOptionsRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RunInstancesRequest
  ): zio.aws.ec2.model.RunInstancesRequest.ReadOnly = new Wrapper(impl)
}
