package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  KeyPairName,
  SecurityGroupId,
  KernelId,
  SecurityGroupName,
  ImageId,
  RamdiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RequestLaunchTemplateData(
    kernelId: Optional[KernelId] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    iamInstanceProfile: Optional[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest
    ] = Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest]
    ] = Optional.Absent,
    networkInterfaces: Optional[Iterable[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest
    ]] = Optional.Absent,
    imageId: Optional[ImageId] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    keyName: Optional[KeyPairName] = Optional.Absent,
    monitoring: Optional[zio.aws.ec2.model.LaunchTemplatesMonitoringRequest] =
      Optional.Absent,
    placement: Optional[zio.aws.ec2.model.LaunchTemplatePlacementRequest] =
      Optional.Absent,
    ramDiskId: Optional[RamdiskId] = Optional.Absent,
    disableApiTermination: Optional[Boolean] = Optional.Absent,
    instanceInitiatedShutdownBehavior: Optional[
      zio.aws.ec2.model.ShutdownBehavior
    ] = Optional.Absent,
    userData: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[
      Iterable[zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest]
    ] = Optional.Absent,
    elasticGpuSpecifications: Optional[
      Iterable[zio.aws.ec2.model.ElasticGpuSpecification]
    ] = Optional.Absent,
    elasticInferenceAccelerators: Optional[
      Iterable[zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator]
    ] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupName]] = Optional.Absent,
    instanceMarketOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest
    ] = Optional.Absent,
    creditSpecification: Optional[
      zio.aws.ec2.model.CreditSpecificationRequest
    ] = Optional.Absent,
    cpuOptions: Optional[zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest] =
      Optional.Absent,
    capacityReservationSpecification: Optional[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest
    ] = Optional.Absent,
    licenseSpecifications: Optional[
      Iterable[zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest]
    ] = Optional.Absent,
    hibernationOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest
    ] = Optional.Absent,
    metadataOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest
    ] = Optional.Absent,
    enclaveOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest
    ] = Optional.Absent,
    instanceRequirements: Optional[
      zio.aws.ec2.model.InstanceRequirementsRequest
    ] = Optional.Absent,
    privateDnsNameOptions: Optional[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest
    ] = Optional.Absent,
    maintenanceOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData = {
    import RequestLaunchTemplateData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData
      .builder()
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        ramDiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramDiskId)
      .optionallyWith(
        disableApiTermination.map(value => value: java.lang.Boolean)
      )(_.disableApiTermination)
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.unwrap)
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        elasticGpuSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuSpecifications)
      .optionallyWith(
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticInferenceAccelerators)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        instanceMarketOptions.map(value => value.buildAwsValue())
      )(_.instanceMarketOptions)
      .optionallyWith(creditSpecification.map(value => value.buildAwsValue()))(
        _.creditSpecification
      )
      .optionallyWith(cpuOptions.map(value => value.buildAwsValue()))(
        _.cpuOptions
      )
      .optionallyWith(
        capacityReservationSpecification.map(value => value.buildAwsValue())
      )(_.capacityReservationSpecification)
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(hibernationOptions.map(value => value.buildAwsValue()))(
        _.hibernationOptions
      )
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .optionallyWith(
        privateDnsNameOptions.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptions)
      .optionallyWith(maintenanceOptions.map(value => value.buildAwsValue()))(
        _.maintenanceOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly =
    zio.aws.ec2.model.RequestLaunchTemplateData.wrap(buildAwsValue())
}
object RequestLaunchTemplateData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestLaunchTemplateData =
      zio.aws.ec2.model.RequestLaunchTemplateData(
        kernelId.map(value => value),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        instanceType.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        placement.map(value => value.asEditable),
        ramDiskId.map(value => value),
        disableApiTermination.map(value => value),
        instanceInitiatedShutdownBehavior.map(value => value),
        userData.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticGpuSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupIds.map(value => value),
        securityGroups.map(value => value),
        instanceMarketOptions.map(value => value.asEditable),
        creditSpecification.map(value => value.asEditable),
        cpuOptions.map(value => value.asEditable),
        capacityReservationSpecification.map(value => value.asEditable),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hibernationOptions.map(value => value.asEditable),
        metadataOptions.map(value => value.asEditable),
        enclaveOptions.map(value => value.asEditable),
        instanceRequirements.map(value => value.asEditable),
        privateDnsNameOptions.map(value => value.asEditable),
        maintenanceOptions.map(value => value.asEditable)
      )
    def kernelId: Optional[KernelId]
    def ebsOptimized: Optional[Boolean]
    def iamInstanceProfile: Optional[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.ReadOnly
    ]
    def blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest.ReadOnly]
    ]
    def networkInterfaces: Optional[List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.ReadOnly
    ]]
    def imageId: Optional[ImageId]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def keyName: Optional[KeyPairName]
    def monitoring
        : Optional[zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.ReadOnly]
    def placement
        : Optional[zio.aws.ec2.model.LaunchTemplatePlacementRequest.ReadOnly]
    def ramDiskId: Optional[RamdiskId]
    def disableApiTermination: Optional[Boolean]
    def instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.ShutdownBehavior]
    def userData: Optional[String]
    def tagSpecifications: Optional[
      List[zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.ReadOnly]
    ]
    def elasticGpuSpecifications
        : Optional[List[zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly]]
    def elasticInferenceAccelerators: Optional[
      List[zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.ReadOnly]
    ]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def securityGroups: Optional[List[SecurityGroupName]]
    def instanceMarketOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.ReadOnly
    ]
    def creditSpecification
        : Optional[zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly]
    def cpuOptions
        : Optional[zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest.ReadOnly]
    def capacityReservationSpecification: Optional[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.ReadOnly
    ]
    def licenseSpecifications: Optional[
      List[zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.ReadOnly]
    ]
    def hibernationOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.ReadOnly
    ]
    def metadataOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.ReadOnly
    ]
    def enclaveOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.ReadOnly
    ]
    def instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly]
    def privateDnsNameOptions: Optional[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.ReadOnly
    ]
    def maintenanceOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.ReadOnly
    ]
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatePlacementRequest.ReadOnly
    ] = AwsError.unwrapOptionField("placement", placement)
    def getRamDiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramDiskId", ramDiskId)
    def getDisableApiTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.ShutdownBehavior] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getElasticGpuSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticGpuSpecifications",
      elasticGpuSpecifications
    )
    def getElasticInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticInferenceAccelerators",
      elasticInferenceAccelerators
    )
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupName]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getInstanceMarketOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceMarketOptions", instanceMarketOptions)
    def getCreditSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("creditSpecification", creditSpecification)
    def getCpuOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("cpuOptions", cpuOptions)
    def getCapacityReservationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationSpecification",
      capacityReservationSpecification
    )
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getHibernationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("hibernationOptions", hibernationOptions)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getEnclaveOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getInstanceRequirements: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
    def getPrivateDnsNameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("privateDnsNameOptions", privateDnsNameOptions)
    def getMaintenanceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("maintenanceOptions", maintenanceOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData
  ) extends zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly {
    override val kernelId: Optional[KernelId] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val iamInstanceProfile: Optional[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.iamInstanceProfile())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest
          .wrap(value)
      )
    override val blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest.wrap(item)
        }.toList
      )
    override val networkInterfaces: Optional[List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest
            .wrap(item)
        }.toList
      )
    override val imageId: Optional[ImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val keyName: Optional[KeyPairName] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val monitoring: Optional[
      zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoring())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.wrap(value)
      )
    override val placement
        : Optional[zio.aws.ec2.model.LaunchTemplatePlacementRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplatePlacementRequest.wrap(value)
        )
    override val ramDiskId: Optional[RamdiskId] = zio.aws.core.internal
      .optionalFromNullable(impl.ramDiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val disableApiTermination: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableApiTermination())
        .map(value => value: Boolean)
    override val instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.ShutdownBehavior] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.ShutdownBehavior.wrap(value))
    override val userData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userData())
      .map(value => value: String)
    override val tagSpecifications: Optional[
      List[zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.wrap(item)
        }.toList
      )
    override val elasticGpuSpecifications
        : Optional[List[zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticGpuSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ElasticGpuSpecification.wrap(item)
          }.toList
        )
    override val elasticInferenceAccelerators: Optional[
      List[zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticInferenceAccelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.wrap(item)
        }.toList
      )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val securityGroups: Optional[List[SecurityGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupName(item)
          }.toList
        )
    override val instanceMarketOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceMarketOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.wrap(value)
      )
    override val creditSpecification
        : Optional[zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creditSpecification())
        .map(value => zio.aws.ec2.model.CreditSpecificationRequest.wrap(value))
    override val cpuOptions
        : Optional[zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuOptions())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest.wrap(value)
        )
    override val capacityReservationSpecification: Optional[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationSpecification())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest
          .wrap(value)
      )
    override val licenseSpecifications: Optional[
      List[zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.wrap(item)
        }.toList
      )
    override val hibernationOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hibernationOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.wrap(value)
      )
    override val metadataOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest
          .wrap(value)
      )
    override val enclaveOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.enclaveOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.wrap(value)
      )
    override val instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceRequirements())
        .map(value => zio.aws.ec2.model.InstanceRequirementsRequest.wrap(value))
    override val privateDnsNameOptions: Optional[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsNameOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.wrap(value)
      )
    override val maintenanceOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData
  ): zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly = new Wrapper(impl)
}
