package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ReportStatusType {
  def unwrap: software.amazon.awssdk.services.ec2.model.ReportStatusType
}
object ReportStatusType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ReportStatusType
  ): zio.aws.ec2.model.ReportStatusType = value match {
    case software.amazon.awssdk.services.ec2.model.ReportStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ReportStatusType.OK =>
      val r = ok
      r
    case software.amazon.awssdk.services.ec2.model.ReportStatusType.IMPAIRED =>
      val r = impaired
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ReportStatusType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportStatusType =
      software.amazon.awssdk.services.ec2.model.ReportStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object ok extends zio.aws.ec2.model.ReportStatusType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportStatusType =
      software.amazon.awssdk.services.ec2.model.ReportStatusType.OK
  }
  case object impaired extends zio.aws.ec2.model.ReportStatusType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReportStatusType =
      software.amazon.awssdk.services.ec2.model.ReportStatusType.IMPAIRED
  }
}
