package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplaceTransitGatewayRouteResponse(
    route: Optional[zio.aws.ec2.model.TransitGatewayRoute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse = {
    import ReplaceTransitGatewayRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse
      .builder()
      .optionallyWith(route.map(value => value.buildAwsValue()))(_.route)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.ReadOnly =
    zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.wrap(buildAwsValue())
}
object ReplaceTransitGatewayRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse =
      zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse(
        route.map(value => value.asEditable)
      )
    def route: Optional[zio.aws.ec2.model.TransitGatewayRoute.ReadOnly]
    def getRoute
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayRoute.ReadOnly] =
      AwsError.unwrapOptionField("route", route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse
  ) extends zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.ReadOnly {
    override val route
        : Optional[zio.aws.ec2.model.TransitGatewayRoute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.route())
        .map(value => zio.aws.ec2.model.TransitGatewayRoute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse
  ): zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.ReadOnly =
    new Wrapper(impl)
}
