package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ProcessorSustainedClockSpeed
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProcessorInfo(
    supportedArchitectures: Optional[
      Iterable[zio.aws.ec2.model.ArchitectureType]
    ] = Optional.Absent,
    sustainedClockSpeedInGhz: Optional[ProcessorSustainedClockSpeed] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProcessorInfo = {
    import ProcessorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProcessorInfo
      .builder()
      .optionallyWith(
        supportedArchitectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedArchitecturesWithStrings)
      .optionallyWith(
        sustainedClockSpeedInGhz.map(value =>
          ProcessorSustainedClockSpeed.unwrap(value): java.lang.Double
        )
      )(_.sustainedClockSpeedInGhz)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProcessorInfo.ReadOnly =
    zio.aws.ec2.model.ProcessorInfo.wrap(buildAwsValue())
}
object ProcessorInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ProcessorInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProcessorInfo =
      zio.aws.ec2.model.ProcessorInfo(
        supportedArchitectures.map(value => value),
        sustainedClockSpeedInGhz.map(value => value)
      )
    def supportedArchitectures
        : Optional[List[zio.aws.ec2.model.ArchitectureType]]
    def sustainedClockSpeedInGhz: Optional[ProcessorSustainedClockSpeed]
    def getSupportedArchitectures
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ArchitectureType]] =
      AwsError.unwrapOptionField(
        "supportedArchitectures",
        supportedArchitectures
      )
    def getSustainedClockSpeedInGhz
        : ZIO[Any, AwsError, ProcessorSustainedClockSpeed] = AwsError
      .unwrapOptionField("sustainedClockSpeedInGhz", sustainedClockSpeedInGhz)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProcessorInfo
  ) extends zio.aws.ec2.model.ProcessorInfo.ReadOnly {
    override val supportedArchitectures
        : Optional[List[zio.aws.ec2.model.ArchitectureType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedArchitectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ArchitectureType.wrap(item)
          }.toList
        )
    override val sustainedClockSpeedInGhz
        : Optional[ProcessorSustainedClockSpeed] = zio.aws.core.internal
      .optionalFromNullable(impl.sustainedClockSpeedInGhz())
      .map(value =>
        zio.aws.ec2.model.primitives.ProcessorSustainedClockSpeed(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProcessorInfo
  ): zio.aws.ec2.model.ProcessorInfo.ReadOnly = new Wrapper(impl)
}
