package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NetworkPerformance,
  MaximumNetworkCards,
  MaxIpv4AddrPerInterface,
  MaxIpv6AddrPerInterface,
  EfaSupportedFlag,
  Ipv6Flag,
  MaxNetworkInterfaces,
  EncryptionInTransitSupported,
  DefaultNetworkCardIndex
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NetworkInfo(
    networkPerformance: Optional[NetworkPerformance] = Optional.Absent,
    maximumNetworkInterfaces: Optional[MaxNetworkInterfaces] = Optional.Absent,
    maximumNetworkCards: Optional[MaximumNetworkCards] = Optional.Absent,
    defaultNetworkCardIndex: Optional[DefaultNetworkCardIndex] =
      Optional.Absent,
    networkCards: Optional[Iterable[zio.aws.ec2.model.NetworkCardInfo]] =
      Optional.Absent,
    ipv4AddressesPerInterface: Optional[MaxIpv4AddrPerInterface] =
      Optional.Absent,
    ipv6AddressesPerInterface: Optional[MaxIpv6AddrPerInterface] =
      Optional.Absent,
    ipv6Supported: Optional[Ipv6Flag] = Optional.Absent,
    enaSupport: Optional[zio.aws.ec2.model.EnaSupport] = Optional.Absent,
    efaSupported: Optional[EfaSupportedFlag] = Optional.Absent,
    efaInfo: Optional[zio.aws.ec2.model.EfaInfo] = Optional.Absent,
    encryptionInTransitSupported: Optional[EncryptionInTransitSupported] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.NetworkInfo = {
    import NetworkInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInfo
      .builder()
      .optionallyWith(
        networkPerformance.map(value =>
          NetworkPerformance.unwrap(value): java.lang.String
        )
      )(_.networkPerformance)
      .optionallyWith(
        maximumNetworkInterfaces.map(value =>
          MaxNetworkInterfaces.unwrap(value): Integer
        )
      )(_.maximumNetworkInterfaces)
      .optionallyWith(
        maximumNetworkCards.map(value =>
          MaximumNetworkCards.unwrap(value): Integer
        )
      )(_.maximumNetworkCards)
      .optionallyWith(
        defaultNetworkCardIndex.map(value =>
          DefaultNetworkCardIndex.unwrap(value): Integer
        )
      )(_.defaultNetworkCardIndex)
      .optionallyWith(
        networkCards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkCards)
      .optionallyWith(
        ipv4AddressesPerInterface.map(value =>
          MaxIpv4AddrPerInterface.unwrap(value): Integer
        )
      )(_.ipv4AddressesPerInterface)
      .optionallyWith(
        ipv6AddressesPerInterface.map(value =>
          MaxIpv6AddrPerInterface.unwrap(value): Integer
        )
      )(_.ipv6AddressesPerInterface)
      .optionallyWith(
        ipv6Supported.map(value => Ipv6Flag.unwrap(value): java.lang.Boolean)
      )(_.ipv6Supported)
      .optionallyWith(enaSupport.map(value => value.unwrap))(_.enaSupport)
      .optionallyWith(
        efaSupported.map(value =>
          EfaSupportedFlag.unwrap(value): java.lang.Boolean
        )
      )(_.efaSupported)
      .optionallyWith(efaInfo.map(value => value.buildAwsValue()))(_.efaInfo)
      .optionallyWith(
        encryptionInTransitSupported.map(value =>
          EncryptionInTransitSupported.unwrap(value): java.lang.Boolean
        )
      )(_.encryptionInTransitSupported)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInfo.ReadOnly =
    zio.aws.ec2.model.NetworkInfo.wrap(buildAwsValue())
}
object NetworkInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.NetworkInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInfo =
      zio.aws.ec2.model.NetworkInfo(
        networkPerformance.map(value => value),
        maximumNetworkInterfaces.map(value => value),
        maximumNetworkCards.map(value => value),
        defaultNetworkCardIndex.map(value => value),
        networkCards.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv4AddressesPerInterface.map(value => value),
        ipv6AddressesPerInterface.map(value => value),
        ipv6Supported.map(value => value),
        enaSupport.map(value => value),
        efaSupported.map(value => value),
        efaInfo.map(value => value.asEditable),
        encryptionInTransitSupported.map(value => value)
      )
    def networkPerformance: Optional[NetworkPerformance]
    def maximumNetworkInterfaces: Optional[MaxNetworkInterfaces]
    def maximumNetworkCards: Optional[MaximumNetworkCards]
    def defaultNetworkCardIndex: Optional[DefaultNetworkCardIndex]
    def networkCards: Optional[List[zio.aws.ec2.model.NetworkCardInfo.ReadOnly]]
    def ipv4AddressesPerInterface: Optional[MaxIpv4AddrPerInterface]
    def ipv6AddressesPerInterface: Optional[MaxIpv6AddrPerInterface]
    def ipv6Supported: Optional[Ipv6Flag]
    def enaSupport: Optional[zio.aws.ec2.model.EnaSupport]
    def efaSupported: Optional[EfaSupportedFlag]
    def efaInfo: Optional[zio.aws.ec2.model.EfaInfo.ReadOnly]
    def encryptionInTransitSupported: Optional[EncryptionInTransitSupported]
    def getNetworkPerformance: ZIO[Any, AwsError, NetworkPerformance] =
      AwsError.unwrapOptionField("networkPerformance", networkPerformance)
    def getMaximumNetworkInterfaces: ZIO[Any, AwsError, MaxNetworkInterfaces] =
      AwsError.unwrapOptionField(
        "maximumNetworkInterfaces",
        maximumNetworkInterfaces
      )
    def getMaximumNetworkCards: ZIO[Any, AwsError, MaximumNetworkCards] =
      AwsError.unwrapOptionField("maximumNetworkCards", maximumNetworkCards)
    def getDefaultNetworkCardIndex
        : ZIO[Any, AwsError, DefaultNetworkCardIndex] = AwsError
      .unwrapOptionField("defaultNetworkCardIndex", defaultNetworkCardIndex)
    def getNetworkCards
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.NetworkCardInfo.ReadOnly]] =
      AwsError.unwrapOptionField("networkCards", networkCards)
    def getIpv4AddressesPerInterface
        : ZIO[Any, AwsError, MaxIpv4AddrPerInterface] = AwsError
      .unwrapOptionField("ipv4AddressesPerInterface", ipv4AddressesPerInterface)
    def getIpv6AddressesPerInterface
        : ZIO[Any, AwsError, MaxIpv6AddrPerInterface] = AwsError
      .unwrapOptionField("ipv6AddressesPerInterface", ipv6AddressesPerInterface)
    def getIpv6Supported: ZIO[Any, AwsError, Ipv6Flag] =
      AwsError.unwrapOptionField("ipv6Supported", ipv6Supported)
    def getEnaSupport: ZIO[Any, AwsError, zio.aws.ec2.model.EnaSupport] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getEfaSupported: ZIO[Any, AwsError, EfaSupportedFlag] =
      AwsError.unwrapOptionField("efaSupported", efaSupported)
    def getEfaInfo: ZIO[Any, AwsError, zio.aws.ec2.model.EfaInfo.ReadOnly] =
      AwsError.unwrapOptionField("efaInfo", efaInfo)
    def getEncryptionInTransitSupported
        : ZIO[Any, AwsError, EncryptionInTransitSupported] =
      AwsError.unwrapOptionField(
        "encryptionInTransitSupported",
        encryptionInTransitSupported
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInfo
  ) extends zio.aws.ec2.model.NetworkInfo.ReadOnly {
    override val networkPerformance: Optional[NetworkPerformance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkPerformance())
        .map(value => zio.aws.ec2.model.primitives.NetworkPerformance(value))
    override val maximumNetworkInterfaces: Optional[MaxNetworkInterfaces] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumNetworkInterfaces())
        .map(value => zio.aws.ec2.model.primitives.MaxNetworkInterfaces(value))
    override val maximumNetworkCards: Optional[MaximumNetworkCards] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumNetworkCards())
        .map(value => zio.aws.ec2.model.primitives.MaximumNetworkCards(value))
    override val defaultNetworkCardIndex: Optional[DefaultNetworkCardIndex] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultNetworkCardIndex())
        .map(value =>
          zio.aws.ec2.model.primitives.DefaultNetworkCardIndex(value)
        )
    override val networkCards
        : Optional[List[zio.aws.ec2.model.NetworkCardInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkCards())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NetworkCardInfo.wrap(item)
          }.toList
        )
    override val ipv4AddressesPerInterface: Optional[MaxIpv4AddrPerInterface] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv4AddressesPerInterface())
        .map(value =>
          zio.aws.ec2.model.primitives.MaxIpv4AddrPerInterface(value)
        )
    override val ipv6AddressesPerInterface: Optional[MaxIpv6AddrPerInterface] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6AddressesPerInterface())
        .map(value =>
          zio.aws.ec2.model.primitives.MaxIpv6AddrPerInterface(value)
        )
    override val ipv6Supported: Optional[Ipv6Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Supported())
      .map(value => zio.aws.ec2.model.primitives.Ipv6Flag(value))
    override val enaSupport: Optional[zio.aws.ec2.model.EnaSupport] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enaSupport())
        .map(value => zio.aws.ec2.model.EnaSupport.wrap(value))
    override val efaSupported: Optional[EfaSupportedFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.efaSupported())
        .map(value => zio.aws.ec2.model.primitives.EfaSupportedFlag(value))
    override val efaInfo: Optional[zio.aws.ec2.model.EfaInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.efaInfo())
        .map(value => zio.aws.ec2.model.EfaInfo.wrap(value))
    override val encryptionInTransitSupported
        : Optional[EncryptionInTransitSupported] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionInTransitSupported())
      .map(value =>
        zio.aws.ec2.model.primitives.EncryptionInTransitSupported(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInfo
  ): zio.aws.ec2.model.NetworkInfo.ReadOnly = new Wrapper(impl)
}
