package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, InstanceEventId}
import scala.jdk.CollectionConverters._
final case class InstanceStatusEvent(
    instanceEventId: Optional[InstanceEventId] = Optional.Absent,
    code: Optional[zio.aws.ec2.model.EventCode] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    notAfter: Optional[DateTime] = Optional.Absent,
    notBefore: Optional[DateTime] = Optional.Absent,
    notBeforeDeadline: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceStatusEvent = {
    import InstanceStatusEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceStatusEvent
      .builder()
      .optionallyWith(
        instanceEventId.map(value =>
          InstanceEventId.unwrap(value): java.lang.String
        )
      )(_.instanceEventId)
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(notAfter.map(value => DateTime.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(notBefore.map(value => DateTime.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(
        notBeforeDeadline.map(value => DateTime.unwrap(value): Instant)
      )(_.notBeforeDeadline)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceStatusEvent.ReadOnly =
    zio.aws.ec2.model.InstanceStatusEvent.wrap(buildAwsValue())
}
object InstanceStatusEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceStatusEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceStatusEvent =
      zio.aws.ec2.model.InstanceStatusEvent(
        instanceEventId.map(value => value),
        code.map(value => value),
        description.map(value => value),
        notAfter.map(value => value),
        notBefore.map(value => value),
        notBeforeDeadline.map(value => value)
      )
    def instanceEventId: Optional[InstanceEventId]
    def code: Optional[zio.aws.ec2.model.EventCode]
    def description: Optional[String]
    def notAfter: Optional[DateTime]
    def notBefore: Optional[DateTime]
    def notBeforeDeadline: Optional[DateTime]
    def getInstanceEventId: ZIO[Any, AwsError, InstanceEventId] =
      AwsError.unwrapOptionField("instanceEventId", instanceEventId)
    def getCode: ZIO[Any, AwsError, zio.aws.ec2.model.EventCode] =
      AwsError.unwrapOptionField("code", code)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getNotAfter: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getNotBefore: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotBeforeDeadline: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("notBeforeDeadline", notBeforeDeadline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatusEvent
  ) extends zio.aws.ec2.model.InstanceStatusEvent.ReadOnly {
    override val instanceEventId: Optional[InstanceEventId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceEventId())
        .map(value => zio.aws.ec2.model.primitives.InstanceEventId(value))
    override val code: Optional[zio.aws.ec2.model.EventCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.ec2.model.EventCode.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val notAfter: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfter())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val notBefore: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.notBefore())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val notBeforeDeadline: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.notBeforeDeadline())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatusEvent
  ): zio.aws.ec2.model.InstanceStatusEvent.ReadOnly = new Wrapper(impl)
}
