package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceSpecification(
    instanceId: Optional[InstanceId] = Optional.Absent,
    excludeBootVolume: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceSpecification = {
    import InstanceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceSpecification
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(excludeBootVolume.map(value => value: java.lang.Boolean))(
        _.excludeBootVolume
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceSpecification.ReadOnly =
    zio.aws.ec2.model.InstanceSpecification.wrap(buildAwsValue())
}
object InstanceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceSpecification =
      zio.aws.ec2.model.InstanceSpecification(
        instanceId.map(value => value),
        excludeBootVolume.map(value => value)
      )
    def instanceId: Optional[InstanceId]
    def excludeBootVolume: Optional[Boolean]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getExcludeBootVolume: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("excludeBootVolume", excludeBootVolume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceSpecification
  ) extends zio.aws.ec2.model.InstanceSpecification.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val excludeBootVolume: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.excludeBootVolume())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceSpecification
  ): zio.aws.ec2.model.InstanceSpecification.ReadOnly = new Wrapper(impl)
}
