package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportImageTask(
    architecture: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    hypervisor: Optional[String] = Optional.Absent,
    imageId: Optional[String] = Optional.Absent,
    importTaskId: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    licenseType: Optional[String] = Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    progress: Optional[String] = Optional.Absent,
    snapshotDetails: Optional[Iterable[zio.aws.ec2.model.SnapshotDetail]] =
      Optional.Absent,
    status: Optional[String] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    licenseSpecifications: Optional[
      Iterable[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse]
    ] = Optional.Absent,
    usageOperation: Optional[String] = Optional.Absent,
    bootMode: Optional[zio.aws.ec2.model.BootModeValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportImageTask = {
    import ImportImageTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportImageTask
      .builder()
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(hypervisor.map(value => value: java.lang.String))(
        _.hypervisor
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(importTaskId.map(value => value: java.lang.String))(
        _.importTaskId
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(licenseType.map(value => value: java.lang.String))(
        _.licenseType
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(
        snapshotDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshotDetails)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportImageTask.ReadOnly =
    zio.aws.ec2.model.ImportImageTask.wrap(buildAwsValue())
}
object ImportImageTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportImageTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportImageTask =
      zio.aws.ec2.model.ImportImageTask(
        architecture.map(value => value),
        description.map(value => value),
        encrypted.map(value => value),
        hypervisor.map(value => value),
        imageId.map(value => value),
        importTaskId.map(value => value),
        kmsKeyId.map(value => value),
        licenseType.map(value => value),
        platform.map(value => value),
        progress.map(value => value),
        snapshotDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        statusMessage.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        usageOperation.map(value => value),
        bootMode.map(value => value)
      )
    def architecture: Optional[String]
    def description: Optional[String]
    def encrypted: Optional[Boolean]
    def hypervisor: Optional[String]
    def imageId: Optional[String]
    def importTaskId: Optional[String]
    def kmsKeyId: Optional[String]
    def licenseType: Optional[String]
    def platform: Optional[String]
    def progress: Optional[String]
    def snapshotDetails
        : Optional[List[zio.aws.ec2.model.SnapshotDetail.ReadOnly]]
    def status: Optional[String]
    def statusMessage: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def licenseSpecifications: Optional[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly]
    ]
    def usageOperation: Optional[String]
    def bootMode: Optional[zio.aws.ec2.model.BootModeValues]
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getHypervisor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getImportTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("importTaskId", importTaskId)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLicenseType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getSnapshotDetails
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.SnapshotDetail.ReadOnly]] =
      AwsError.unwrapOptionField("snapshotDetails", snapshotDetails)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageTask
  ) extends zio.aws.ec2.model.ImportImageTask.ReadOnly {
    override val architecture: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.architecture())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val hypervisor: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisor())
      .map(value => value: String)
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val importTaskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.importTaskId())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val licenseType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseType())
      .map(value => value: String)
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val progress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.progress())
      .map(value => value: String)
    override val snapshotDetails
        : Optional[List[zio.aws.ec2.model.SnapshotDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SnapshotDetail.wrap(item)
          }.toList
        )
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val licenseSpecifications: Optional[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.wrap(item)
        }.toList
      )
    override val usageOperation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usageOperation())
      .map(value => value: String)
    override val bootMode: Optional[zio.aws.ec2.model.BootModeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageTask
  ): zio.aws.ec2.model.ImportImageTask.ReadOnly = new Wrapper(impl)
}
