package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class IamInstanceProfileAssociation(
    associationId: Optional[String] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    iamInstanceProfile: Optional[zio.aws.ec2.model.IamInstanceProfile] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.IamInstanceProfileAssociationState] =
      Optional.Absent,
    timestamp: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation = {
    import IamInstanceProfileAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(timestamp.map(value => DateTime.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly =
    zio.aws.ec2.model.IamInstanceProfileAssociation.wrap(buildAwsValue())
}
object IamInstanceProfileAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IamInstanceProfileAssociation =
      zio.aws.ec2.model.IamInstanceProfileAssociation(
        associationId.map(value => value),
        instanceId.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        state.map(value => value),
        timestamp.map(value => value)
      )
    def associationId: Optional[String]
    def instanceId: Optional[String]
    def iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfile.ReadOnly]
    def state: Optional[zio.aws.ec2.model.IamInstanceProfileAssociationState]
    def timestamp: Optional[DateTime]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getIamInstanceProfile
        : ZIO[Any, AwsError, zio.aws.ec2.model.IamInstanceProfile.ReadOnly] =
      AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileAssociationState
    ] = AwsError.unwrapOptionField("state", state)
    def getTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation
  ) extends zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly {
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfile())
        .map(value => zio.aws.ec2.model.IamInstanceProfile.wrap(value))
    override val state
        : Optional[zio.aws.ec2.model.IamInstanceProfileAssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileAssociationState.wrap(value)
        )
    override val timestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation
  ): zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly = new Wrapper(
    impl
  )
}
