package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetManagedPrefixListEntriesResponse(
    entries: Optional[Iterable[zio.aws.ec2.model.PrefixListEntry]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse = {
    import GetManagedPrefixListEntriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse
      .builder()
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.ReadOnly =
    zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.wrap(buildAwsValue())
}
object GetManagedPrefixListEntriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetManagedPrefixListEntriesResponse =
      zio.aws.ec2.model.GetManagedPrefixListEntriesResponse(
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entries: Optional[List[zio.aws.ec2.model.PrefixListEntry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEntries
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PrefixListEntry.ReadOnly]] =
      AwsError.unwrapOptionField("entries", entries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse
  ) extends zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.ReadOnly {
    override val entries
        : Optional[List[zio.aws.ec2.model.PrefixListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PrefixListEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse
  ): zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.ReadOnly =
    new Wrapper(impl)
}
