package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetManagedPrefixListAssociationsResponse(
    prefixListAssociations: Optional[
      Iterable[zio.aws.ec2.model.PrefixListAssociation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse = {
    import GetManagedPrefixListAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse
      .builder()
      .optionallyWith(
        prefixListAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixListAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse
      .wrap(buildAwsValue())
}
object GetManagedPrefixListAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse =
      zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse(
        prefixListAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def prefixListAssociations
        : Optional[List[zio.aws.ec2.model.PrefixListAssociation.ReadOnly]]
    def nextToken: Optional[String]
    def getPrefixListAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrefixListAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "prefixListAssociations",
      prefixListAssociations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse
  ) extends zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly {
    override val prefixListAssociations
        : Optional[List[zio.aws.ec2.model.PrefixListAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PrefixListAssociation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse
  ): zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
