package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGroupsForCapacityReservationResponse(
    nextToken: Optional[String] = Optional.Absent,
    capacityReservationGroups: Optional[
      Iterable[zio.aws.ec2.model.CapacityReservationGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse = {
    import GetGroupsForCapacityReservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        capacityReservationGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityReservationGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetGroupsForCapacityReservationResponse.ReadOnly =
    zio.aws.ec2.model.GetGroupsForCapacityReservationResponse
      .wrap(buildAwsValue())
}
object GetGroupsForCapacityReservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetGroupsForCapacityReservationResponse =
      zio.aws.ec2.model.GetGroupsForCapacityReservationResponse(
        nextToken.map(value => value),
        capacityReservationGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def capacityReservationGroups
        : Optional[List[zio.aws.ec2.model.CapacityReservationGroup.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCapacityReservationGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CapacityReservationGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityReservationGroups",
      capacityReservationGroups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse
  ) extends zio.aws.ec2.model.GetGroupsForCapacityReservationResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val capacityReservationGroups
        : Optional[List[zio.aws.ec2.model.CapacityReservationGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CapacityReservationGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse
  ): zio.aws.ec2.model.GetGroupsForCapacityReservationResponse.ReadOnly =
    new Wrapper(impl)
}
