package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait GatewayType {
  def unwrap: software.amazon.awssdk.services.ec2.model.GatewayType
}
object GatewayType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.GatewayType
  ): zio.aws.ec2.model.GatewayType = value match {
    case software.amazon.awssdk.services.ec2.model.GatewayType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.GatewayType.IPSEC_1 =>
      val r = `ipsec.1`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.GatewayType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.GatewayType =
      software.amazon.awssdk.services.ec2.model.GatewayType.UNKNOWN_TO_SDK_VERSION
  }
  case object `ipsec.1` extends zio.aws.ec2.model.GatewayType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.GatewayType =
      software.amazon.awssdk.services.ec2.model.GatewayType.IPSEC_1
  }
}
