package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{FleetId, DateTime}
import scala.jdk.CollectionConverters._
final case class FleetData(
    activityStatus: Optional[zio.aws.ec2.model.FleetActivityStatus] =
      Optional.Absent,
    createTime: Optional[DateTime] = Optional.Absent,
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetState: Optional[zio.aws.ec2.model.FleetStateCode] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    excessCapacityTerminationPolicy: Optional[
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = Optional.Absent,
    fulfilledCapacity: Optional[Double] = Optional.Absent,
    fulfilledOnDemandCapacity: Optional[Double] = Optional.Absent,
    launchTemplateConfigs: Optional[
      Iterable[zio.aws.ec2.model.FleetLaunchTemplateConfig]
    ] = Optional.Absent,
    targetCapacitySpecification: Optional[
      zio.aws.ec2.model.TargetCapacitySpecification
    ] = Optional.Absent,
    terminateInstancesWithExpiration: Optional[Boolean] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.FleetType] = Optional.Absent,
    validFrom: Optional[DateTime] = Optional.Absent,
    validUntil: Optional[DateTime] = Optional.Absent,
    replaceUnhealthyInstances: Optional[Boolean] = Optional.Absent,
    spotOptions: Optional[zio.aws.ec2.model.SpotOptions] = Optional.Absent,
    onDemandOptions: Optional[zio.aws.ec2.model.OnDemandOptions] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.ec2.model.DescribeFleetError]] =
      Optional.Absent,
    instances: Optional[Iterable[zio.aws.ec2.model.DescribeFleetsInstances]] =
      Optional.Absent,
    context: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.FleetData = {
    import FleetData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetData
      .builder()
      .optionallyWith(activityStatus.map(value => value.unwrap))(
        _.activityStatus
      )
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(fleetState.map(value => value.unwrap))(_.fleetState)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        excessCapacityTerminationPolicy.map(value => value.unwrap)
      )(_.excessCapacityTerminationPolicy)
      .optionallyWith(fulfilledCapacity.map(value => value: java.lang.Double))(
        _.fulfilledCapacity
      )
      .optionallyWith(
        fulfilledOnDemandCapacity.map(value => value: java.lang.Double)
      )(_.fulfilledOnDemandCapacity)
      .optionallyWith(
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplateConfigs)
      .optionallyWith(
        targetCapacitySpecification.map(value => value.buildAwsValue())
      )(_.targetCapacitySpecification)
      .optionallyWith(
        terminateInstancesWithExpiration.map(value => value: java.lang.Boolean)
      )(_.terminateInstancesWithExpiration)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        replaceUnhealthyInstances.map(value => value: java.lang.Boolean)
      )(_.replaceUnhealthyInstances)
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .optionallyWith(onDemandOptions.map(value => value.buildAwsValue()))(
        _.onDemandOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetData.ReadOnly =
    zio.aws.ec2.model.FleetData.wrap(buildAwsValue())
}
object FleetData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.FleetData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetData = zio.aws.ec2.model.FleetData(
      activityStatus.map(value => value),
      createTime.map(value => value),
      fleetId.map(value => value),
      fleetState.map(value => value),
      clientToken.map(value => value),
      excessCapacityTerminationPolicy.map(value => value),
      fulfilledCapacity.map(value => value),
      fulfilledOnDemandCapacity.map(value => value),
      launchTemplateConfigs.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      targetCapacitySpecification.map(value => value.asEditable),
      terminateInstancesWithExpiration.map(value => value),
      `type`.map(value => value),
      validFrom.map(value => value),
      validUntil.map(value => value),
      replaceUnhealthyInstances.map(value => value),
      spotOptions.map(value => value.asEditable),
      onDemandOptions.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      errors.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      instances.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      context.map(value => value)
    )
    def activityStatus: Optional[zio.aws.ec2.model.FleetActivityStatus]
    def createTime: Optional[DateTime]
    def fleetId: Optional[FleetId]
    def fleetState: Optional[zio.aws.ec2.model.FleetStateCode]
    def clientToken: Optional[String]
    def excessCapacityTerminationPolicy
        : Optional[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy]
    def fulfilledCapacity: Optional[Double]
    def fulfilledOnDemandCapacity: Optional[Double]
    def launchTemplateConfigs
        : Optional[List[zio.aws.ec2.model.FleetLaunchTemplateConfig.ReadOnly]]
    def targetCapacitySpecification
        : Optional[zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly]
    def terminateInstancesWithExpiration: Optional[Boolean]
    def `type`: Optional[zio.aws.ec2.model.FleetType]
    def validFrom: Optional[DateTime]
    def validUntil: Optional[DateTime]
    def replaceUnhealthyInstances: Optional[Boolean]
    def spotOptions: Optional[zio.aws.ec2.model.SpotOptions.ReadOnly]
    def onDemandOptions: Optional[zio.aws.ec2.model.OnDemandOptions.ReadOnly]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def errors: Optional[List[zio.aws.ec2.model.DescribeFleetError.ReadOnly]]
    def instances
        : Optional[List[zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly]]
    def context: Optional[String]
    def getActivityStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetActivityStatus] =
      AwsError.unwrapOptionField("activityStatus", activityStatus)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetState: ZIO[Any, AwsError, zio.aws.ec2.model.FleetStateCode] =
      AwsError.unwrapOptionField("fleetState", fleetState)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExcessCapacityTerminationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = AwsError.unwrapOptionField(
      "excessCapacityTerminationPolicy",
      excessCapacityTerminationPolicy
    )
    def getFulfilledCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fulfilledCapacity", fulfilledCapacity)
    def getFulfilledOnDemandCapacity: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("fulfilledOnDemandCapacity", fulfilledOnDemandCapacity)
    def getLaunchTemplateConfigs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetLaunchTemplateConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchTemplateConfigs", launchTemplateConfigs)
    def getTargetCapacitySpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetCapacitySpecification",
      targetCapacitySpecification
    )
    def getTerminateInstancesWithExpiration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "terminateInstancesWithExpiration",
        terminateInstancesWithExpiration
      )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.FleetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getReplaceUnhealthyInstances: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("replaceUnhealthyInstances", replaceUnhealthyInstances)
    def getSpotOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotOptions.ReadOnly] =
      AwsError.unwrapOptionField("spotOptions", spotOptions)
    def getOnDemandOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.OnDemandOptions.ReadOnly] =
      AwsError.unwrapOptionField("onDemandOptions", onDemandOptions)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DescribeFleetError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetData
  ) extends zio.aws.ec2.model.FleetData.ReadOnly {
    override val activityStatus
        : Optional[zio.aws.ec2.model.FleetActivityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStatus())
        .map(value => zio.aws.ec2.model.FleetActivityStatus.wrap(value))
    override val createTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.ec2.model.primitives.FleetId(value))
    override val fleetState: Optional[zio.aws.ec2.model.FleetStateCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetState())
        .map(value => zio.aws.ec2.model.FleetStateCode.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val excessCapacityTerminationPolicy
        : Optional[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excessCapacityTerminationPolicy())
        .map(value =>
          zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy.wrap(value)
        )
    override val fulfilledCapacity: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fulfilledCapacity())
      .map(value => value: Double)
    override val fulfilledOnDemandCapacity: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fulfilledOnDemandCapacity())
        .map(value => value: Double)
    override val launchTemplateConfigs
        : Optional[List[zio.aws.ec2.model.FleetLaunchTemplateConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.FleetLaunchTemplateConfig.wrap(item)
          }.toList
        )
    override val targetCapacitySpecification
        : Optional[zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetCapacitySpecification())
        .map(value => zio.aws.ec2.model.TargetCapacitySpecification.wrap(value))
    override val terminateInstancesWithExpiration: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminateInstancesWithExpiration())
        .map(value => value: Boolean)
    override val `type`: Optional[zio.aws.ec2.model.FleetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.FleetType.wrap(value))
    override val validFrom: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val replaceUnhealthyInstances: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replaceUnhealthyInstances())
        .map(value => value: Boolean)
    override val spotOptions: Optional[zio.aws.ec2.model.SpotOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotOptions())
        .map(value => zio.aws.ec2.model.SpotOptions.wrap(value))
    override val onDemandOptions
        : Optional[zio.aws.ec2.model.OnDemandOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandOptions())
        .map(value => zio.aws.ec2.model.OnDemandOptions.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val errors
        : Optional[List[zio.aws.ec2.model.DescribeFleetError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DescribeFleetError.wrap(item)
          }.toList
        )
    override val instances
        : Optional[List[zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DescribeFleetsInstances.wrap(item)
          }.toList
        )
    override val context: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.context())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetData
  ): zio.aws.ec2.model.FleetData.ReadOnly = new Wrapper(impl)
}
